from dotenv import load_dotenv
from openai import AzureOpenAI
from azure.identity import DefaultAzureCredential, get_bearer_token_provider
import json
import re
import pandas as pd
import os
import subprocess
import io
import sys
from openai import OpenAI
from typing_extensions import override
from openai import AssistantEventHandler
from generation_models import message_construct_func, GPT_response, count_total_tokens
import copy
import argparse
import tqdm
import time
import numpy as np
import ast
from prompt import *
from argparse import ArgumentParser

def extract_code(text):
    # Regular expression to match code blocks enclosed in triple backticks
    code_block_pattern = re.compile(r'```python\n(.*?)\n```', re.DOTALL)

    # Find all matches in the text
    code_blocks = code_block_pattern.findall(text)

    # If no code blocks are found, try to find indented code blocks
    if not code_blocks:
        return []

    return code_blocks

def extract_equation_with_GPT4(response):
    prompt = 'Your task is to extract the final numerical answer of the given answer by another LLM:\n' \
             'Here is the response, return your answer with the format <<<list>>>, like <<<43243.4>>>.\n' \
             'If the input text does not have <<<>>> and is already the pure answer, add <<<>>> and return your answer.\n' \
             'Note that if you find no final answer is answered, then directly answer <<<No answer found>>>.\n' \
             'Input text: ' \

    extract_equation = GPT_response('', prompt + response, model_name='gpt-4o', code_interpreter=False, user_prompt_list = [prompt + response], response_total_list = [])
    return extract_equation

def extract_and_check(response):
    # Extract all texts between <<< and >>>
    matches = re.findall(r'<<<(.*?)>>>', response)
    extracted_text = matches[-1].strip() if matches else ''

    # Check if 'itertools' appears in the response
    itertools_present = '```python' in response

    return extracted_text, itertools_present

def last_boxed_only_string(string):
    idx = string.rfind("\\boxed")
    if idx < 0:
        idx = string.rfind("\\fbox")
        if idx < 0:
            return None

    i = idx
    right_brace_idx = None
    num_left_braces_open = 0
    while i < len(string):
        if string[i] == "{":
            num_left_braces_open += 1
        if string[i] == "}":
            num_left_braces_open -= 1
            if num_left_braces_open == 0:
                right_brace_idx = i
                break
        i += 1

    if right_brace_idx == None:
        retval = None
    else:
        retval = string[idx:right_brace_idx + 1]

    return retval


def remove_boxed(s):
    left = "\\boxed{"
    try:
        assert s[:len(left)] == left
        assert s[-1] == "}"
        return s[len(left):-1]
    except:
        return None

def run_gsm(dataset_input_dir, save_input_dir, model_name, AutoGen_prompt_system_message,
               AutoGen_prompt_concatenate, code_interpreter, Encourage_code_execution_interpreter, all_code_with_COT,
               all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num, method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first):
    print('\n' + '*'*30)
    print(f'Model_name: {model_name}, AutoGen_prompt_system_message: {AutoGen_prompt_system_message}, '
          f'AutoGen_prompt_concatenate: {AutoGen_prompt_concatenate}, code_interpreter: {code_interpreter}, Encourage_code_execution_interpreter: {Encourage_code_execution_interpreter}, '
          f'all_code_with_COT: {all_code_with_COT}, all_code_without_COT: {all_code_without_COT}, all_text: {all_text}, multi_turn_planning: {multi_turn_planning}, multi_turn_planning_round_num: {multi_turn_planning_round_num}, '
          f'method_9_{method_9_all_text_all_code_summarizer}, method_10_{method_10_LLM_estimates_scores_first}\n')

    total_test_num = 0
    num_with_code = 0
    num_without_code = 0
    time_with_code = 0
    time_without_code = 0

    if method_9_all_text_all_code_summarizer == False and method_10_LLM_estimates_scores_first == False:
        base_save_code_dir = save_input_dir + f'/result_gsm_{model_name}_interpreter_{code_interpreter}_AutoGen_system_{AutoGen_prompt_system_message}_AutoGen_concatenate_{AutoGen_prompt_concatenate}_all_code_with_COT_{all_code_with_COT}_all_code_without_COT_{all_code_without_COT}_Encourage_code_execution_interpreter_{Encourage_code_execution_interpreter}_all_text_{all_text}_multi_turn_planning_{multi_turn_planning}_round_num_{multi_turn_planning_round_num}'
    elif method_9_all_text_all_code_summarizer == True and method_10_LLM_estimates_scores_first == False:
        base_save_code_dir = save_input_dir + f'/result_gsm_{model_name}_method_9_all_text_all_code_summarizer'
    elif method_9_all_text_all_code_summarizer == False and method_10_LLM_estimates_scores_first == True:
        base_save_code_dir = save_input_dir + f'/result_gsm_{model_name}_method_10_LLM_estimates_scores_first'
    else:
        raise ValueError(
            "method_9_all_text_all_code_summarizer and method_10_LLM_estimates_scores_first can't be both True")

    if not os.path.exists(base_save_code_dir):
        os.makedirs(base_save_code_dir)


    DATA_PATH = dataset_input_dir + f'/gsmhardv2.jsonl'

    question_json_list = []
    with open(DATA_PATH, 'r') as file:
        for line in file:
            question_json_list.append(json.loads(line))

    print(f'len(question_json_list): {len(question_json_list)}')
    for i in range(0, len(question_json_list), 5):
            with_code = False
            total_test_num += 1
            print('-------###-------###-------###-------')
            print(f'Current num is: {total_test_num}, Total num is: {int(len(question_json_list)/5)}\n')

            save_code_dir = os.path.join(base_save_code_dir, f"Sample_{i}/")
            if not os.path.exists(save_code_dir):
                os.makedirs(save_code_dir)

            data = question_json_list[i]
            question = data['input'] + f'\n' + f'\nOutput final answer with the format <<<answer>>> such as <<<123.42>>>, <<<125.0>>>, <<<-9867>>>.\nYour answer: '
            target_answer = data['target']

            response_total_list = [];
            system_message = ""

            if method_9_all_text_all_code_summarizer == True and method_10_LLM_estimates_scores_first == False:
                base_save_code_dir_all_text = save_input_dir + f'/result_gsm_{model_name}_interpreter_False_AutoGen_system_False_AutoGen_concatenate_False_all_code_with_COT_False_all_code_without_COT_False_Encourage_code_execution_interpreter_False_all_text_True_multi_turn_planning_True_round_num_{multi_turn_planning_round_num}'
                base_save_code_dir_all_code = save_input_dir + f'/result_gsm_{model_name}_interpreter_False_AutoGen_system_False_AutoGen_concatenate_False_all_code_with_COT_False_all_code_without_COT_True_Encourage_code_execution_interpreter_False_all_text_False_multi_turn_planning_True_round_num_{multi_turn_planning_round_num}'
                save_code_dir_all_text = os.path.join(base_save_code_dir_all_text, f"Sample_{i}/")
                save_code_dir_all_code = os.path.join(base_save_code_dir_all_code, f"Sample_{i}/")
                with open(save_code_dir_all_text + f"/response_code_1.txt", "r") as f:
                    response_all_text = f.read()
                with open(save_code_dir_all_code + f"/response_code_1.txt", "r") as f:
                    response_all_code = f.read()
                input_prompt = combined_agent_prompt + '###The input question is: \n' + question + f'\n\n'
                input_prompt = input_prompt + f'\nThe response from Agent_1 is: {response_all_text}'

                if os.path.exists(save_code_dir_all_text + f"/code_1_0.py"):
                    with open(save_code_dir_all_text + f"/extracted_answer_1.txt", "r") as f:
                        extracted_all_text = f.read()
                    input_prompt = input_prompt + f'\nThe execution result from the Agent_1 code is: {extracted_all_text}'

                input_prompt = input_prompt + f'\n\nThe response from Agent_2 is: {response_all_code}'
                if os.path.exists(save_code_dir_all_code + f"/code_1_0.py"):
                    with open(save_code_dir_all_code + f"/extracted_answer_1.txt", "r") as f:
                        extracted_all_code = f.read()
                    input_prompt = input_prompt + f'\nThe execution result from the Agent_2 code is: {extracted_all_code}'
                input_prompt = input_prompt + f'\n\nNow you need to analyze the problem based on their answers and output final answer with the required format in the original question. Your analysis and answer:\n'

                # print(f'\n#########input_prompt: \n{input_prompt}')
                user_prompt_list = [input_prompt]

            elif method_9_all_text_all_code_summarizer == False and method_10_LLM_estimates_scores_first == True:
                user_prompt_list = [method_10_self_estimate_score_prompt + question]
            elif Encourage_code_execution_interpreter == True and code_interpreter == True and all_code_with_COT == False and all_code_without_COT == False and all_text == False:
                user_prompt_list = [Encourage_code_execution_prompt_for_code_interpreter + question]
            elif AutoGen_prompt_system_message == True and AutoGen_prompt_concatenate == False and all_code_with_COT == False and all_code_without_COT == False and all_text == False:
                system_message = AutoGen_prompt
                user_prompt_list = [question]
            elif AutoGen_prompt_system_message == False and AutoGen_prompt_concatenate == True and all_code_with_COT == False and all_code_without_COT == False and all_text == False:
                user_prompt_list = [AutoGen_prompt + question]
            elif AutoGen_prompt_system_message == False and AutoGen_prompt_concatenate == False and all_code_with_COT == False and all_code_without_COT == False and all_text == False:
                user_prompt_list = [question]
            elif code_interpreter == False and all_code_with_COT == True and all_code_without_COT == False and all_text == False:
                user_prompt_list = [with_COT_all_code_prompt_2 + question]
            elif code_interpreter == False and all_code_with_COT == False and all_code_without_COT == True and all_text == False:
                user_prompt_list = [without_COT_all_code_prompt_1 + question]
            elif code_interpreter == False and all_code_with_COT == False and all_code_without_COT == False and all_text == True:
                user_prompt_list = [text_output_prompt + question]
            with open(save_code_dir + f"/system_message.txt", "w") as f:
                f.write(system_message)

            with open(save_code_dir + f'/target_answer.txt', 'w') as f:
                f.write(str(target_answer))

            if multi_turn_planning:
                round_number = multi_turn_planning_round_num
            else:
                round_number = 1

            execution_time_total = 0
            for round_index in range(round_number):
                with open(save_code_dir + f"/input_prompt_{round_index + 1}.txt", "w") as f:
                    f.write(user_prompt_list[round_index])

                print(f'Round {round_index + 1}')
                start_time = time.time()

                # 15000 tokens limit for gpt-3.5-turbo
                if count_total_tokens(user_prompt_list, response_total_list) > 15000 and model_name in ['gpt-3.5-turbo', 'gpt-35-turbo-16k-0613']:
                    break

                response_code = GPT_response("", user_prompt_list[0], model_name=model_name,
                                             code_interpreter=code_interpreter, user_prompt_list=user_prompt_list,
                                             response_total_list=response_total_list)

                print(f'response_{round_index+1}: {response_code}')

                if response_code == None:
                    response_code = 'No response'

                code_block_list = extract_code(response_code)
                for index_code, code_string in enumerate(code_block_list):
                    with open(save_code_dir + f"/code_{round_index + 1}_{index_code}.txt", "w") as f:
                        f.write(code_string)
                with open(save_code_dir + f"/response_code_{round_index + 1}.txt", "w") as f:
                    f.write(response_code)
                if 'TERMINATE' in response_code:
                    print(f'Terminate in round {round_index + 1}. Completed!')
                    end_time = time.time()
                    execution_time = end_time - start_time
                    execution_time_total += execution_time
                    with open(save_code_dir + f"/execution_time_{round_index + 1}.txt", "w") as f:
                        f.write(str(execution_time))
                    break
                elif os.path.exists(save_code_dir + f"/code_{round_index + 1}_0.py"):
                    with_code = True
                    try:
                        result = subprocess.run(
                            ["python3", save_code_dir + f"/code_{round_index + 1}_0.py"],
                            capture_output=True, text=True, timeout=10
                        )
                        output = result.stdout
                        errors = result.stderr
                    except subprocess.TimeoutExpired as e:
                        output = e.stdout if e.stdout else ""
                        errors = e.stderr if e.stderr else ""
                        errors += f"\nTimeoutExpired: Command '{e.cmd}' timed out after {e.timeout} seconds"

                    multi_turn_question = multi_turn_planning_prompt_with_code + f'The execution result from the code is:\noutput: {output}, errors: {errors}'
                    user_prompt_list.append(multi_turn_question)
                    response_total_list.append(response_code)
                    end_time = time.time()
                    execution_time = end_time - start_time
                    execution_time_total += execution_time
                    with open(save_code_dir + f"/execution_time_{round_index + 1}.txt", "w") as f:
                        f.write(str(execution_time))
                else:
                    # print(f'No code generated in round {round_index + 1}. Completed!')
                    multi_turn_question = multi_turn_planning_prompt_without_code
                    user_prompt_list.append(multi_turn_question)
                    response_total_list.append(response_code)

                    end_time = time.time()
                    execution_time = end_time - start_time
                    execution_time_total += execution_time
                    with open(save_code_dir + f"/execution_time_{round_index + 1}.txt", "w") as f:
                        f.write(str(execution_time))

            if with_code:
                num_with_code += 1
                time_with_code += execution_time_total
            else:
                num_without_code += 1
                time_without_code += execution_time_total

    print(
        f'ratio_with_code: {num_with_code / total_test_num}, ratio_without_code: {num_without_code / total_test_num}')
    if num_with_code != 0:
        print(f'average_time_with_code: {time_with_code / num_with_code}')
        with open(base_save_code_dir + f"/average_time_with_code.txt", "w") as f:
            f.write(str(time_with_code / num_with_code))
    if num_without_code != 0:
        print(f'average_time_without_code: {time_without_code / num_without_code}')
        with open(base_save_code_dir + f"/average_time_without_code.txt", "w") as f:
            f.write(str(time_without_code / num_without_code))

    print(f'Model_name: {model_name}, AutoGen_prompt_system_message: {AutoGen_prompt_system_message}, '
          f'AutoGen_prompt_concatenate: {AutoGen_prompt_concatenate}, code_interpreter: {code_interpreter}, Encourage_code_execution_interpreter: {Encourage_code_execution_interpreter}, '
          f'all_code_with_COT: {all_code_with_COT}, all_code_without_COT: {all_code_without_COT}, all_text: {all_text}, multi_turn_planning: {multi_turn_planning}, multi_turn_planning_round_num: {multi_turn_planning_round_num}, '
          f'method_9_{method_9_all_text_all_code_summarizer}, method_10_{method_10_LLM_estimates_scores_first}\n')
    print('*' * 30)

if __name__ == '__main__':
    # gpt-4o, gpt-4o-mini, gpt-3.5-turbo for OpenAi API
    # gpt-4o, gpt-35-turbo for Azure API
    # multi_turn_planning_round_num = [1, 2, 4, 8, 16]

    parser = ArgumentParser()
    parser.add_argument('-model_name', '--model_name', default='gpt-35-turbo-16k-0613')
    args = parser.parse_args()
    model_name = args.model_name

    dataset_input_dir = '../dataset_gather'
    save_input_dir = '../results_gather/gsm'

    if not os.path.exists(save_input_dir):
        os.makedirs(save_input_dir)

    def log_run_info(log_file, run_info):
        with open(log_file, 'a') as f:
            f.write(run_info + "\n")

    # for multi_turn_planning_round_num in [1, 2, 4, 8, 16]:
    for multi_turn_planning_round_num in [1]:
        # for model_name in ['gpt-4o', 'gpt-4o-mini', 'gpt-3.5-turbo', 'gpt-35-turbo-16k-0613']:
        # for model_name in ['gpt-4o']:
        log_file = os.path.join(save_input_dir, f"run_log_{model_name}.txt")

        for dataset_input_dir, save_input_dir, model_name, code_interpreter, AutoGen_prompt_system_message, AutoGen_prompt_concatenate, \
            Encourage_code_execution_interpreter, all_code_with_COT, all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num \
                , method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first in [
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, False, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, True, False, False, False, False, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, True, False, False, False, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, False, True, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, True, False, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, True, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, False, False, True,
             multi_turn_planning_round_num, True, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, False, False, True,
             multi_turn_planning_round_num, False, True),
        ]:
            run_gsm(dataset_input_dir, save_input_dir, model_name, AutoGen_prompt_system_message,
                             AutoGen_prompt_concatenate, code_interpreter, Encourage_code_execution_interpreter,
                             all_code_with_COT,
                             all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num,
                             method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first)

            # Log the completed run
            run_info = f"Completed run: {model_name}, round_num={multi_turn_planning_round_num}, " \
                       f"{code_interpreter}, {AutoGen_prompt_system_message}, {AutoGen_prompt_concatenate}, " \
                       f"{Encourage_code_execution_interpreter}, {all_code_with_COT}, {all_code_without_COT}, {all_text}, {multi_turn_planning}, multi_turn_planning_round_num: {multi_turn_planning_round_num}" \
                       f"\nmethod_9_{method_9_all_text_all_code_summarizer}, method_10_{method_10_LLM_estimates_scores_first}\n"
            log_run_info(log_file, run_info)

    #for model_name in ['gpt-4o', 'gpt-4o-mini', 'gpt-3.5-turbo', 'gpt-35-turbo-16k-0613']:
    #for model_name in ['gpt-4o']:
    log_file = os.path.join(save_input_dir, f"run_log_{model_name}.txt")

    for dataset_input_dir, save_input_dir, model_name, code_interpreter, AutoGen_prompt_system_message, AutoGen_prompt_concatenate, \
        Encourage_code_execution_interpreter, all_code_with_COT, all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num\
        ,method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first in [
        (dataset_input_dir, save_input_dir, model_name, True, False, False, False, False, False, False, False, 1, False, False),
        (dataset_input_dir, save_input_dir, model_name, True, False, False, True, False, False, False, False, 1, False, False)
    ]:
        run_gsm(dataset_input_dir, save_input_dir, model_name, AutoGen_prompt_system_message,
                      AutoGen_prompt_concatenate, code_interpreter, Encourage_code_execution_interpreter,
                      all_code_with_COT,
                      all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num, method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first)

        # Log the completed run
        run_info = f"Completed run: {model_name}, round_num={multi_turn_planning_round_num}, " \
                   f"{code_interpreter}, {AutoGen_prompt_system_message}, {AutoGen_prompt_concatenate}, " \
                   f"{Encourage_code_execution_interpreter}, {all_code_with_COT}, {all_code_without_COT}, {all_text}, {multi_turn_planning}, multi_turn_planning_round_num: {multi_turn_planning_round_num}" \
                   f"\nmethod_9_{method_9_all_text_all_code_summarizer}, method_10_{method_10_LLM_estimates_scores_first}\n"
        log_run_info(log_file, run_info)