import argparse
import faiss
import pickle
import numpy as np

def construct_index(args):
    with open(args.corpus_embeddings_path, 'rb') as f:
        reps, lookup = pickle.load(f)
    reps = np.array(reps)
    index = faiss.IndexFlatIP(reps.shape[1])
    index.add(reps)
    faiss.write_index(index, args.index_output_path)

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--corpus_embeddings_path", type=str, required=True)
    parser.add_argument("--index_output_path", type=str, required=True)
    args = parser.parse_args()
    construct_index(args)