#!/bin/bash -l
#
# SLURM array over (downstream_task × evaluation_scheme × model)
#
#SBATCH --cluster=xxx
#SBATCH --partition=xxx
#SBATCH --time=72:00:00
#SBATCH --account=xxx
#SBATCH --job-name="wandb_alzheimer_classic%a"
#SBATCH --array=0-3
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=16
#SBATCH --gpus-per-node=1
#SBATCH --mail-type=END,FAIL,TIME_LIMIT
#SBATCH --mail-user=xxxxxxx

#SBATCH --chdir=xxxxx
#SBATCH --output=./%x-%A_%a.out
#SBATCH --error=./%x-%A_%a.error

# 1) Activate Python env


# 2) W&B credentials
export WANDB_ENTITY="xxx"
export WANDB_PROJECT="xxx"
export WANDB_CACHE_DIR="xxxx"

# 3) Define grid
downstream_tasks=(alzheimer)
evaluation_schemes=(leave-one-out-finetuning)
models=(deepconvnet eegnet conformer ctnnet)

N1=${#downstream_tasks[@]}     # = 1
N2=${#evaluation_schemes[@]}   # = 1
N3=${#models[@]}               # = 4

# Map SLURM_ARRAY_TASK_ID → i, j, k
idx=$SLURM_ARRAY_TASK_ID
i=$(( idx / (N2 * N3) ))         # will always be 0 since N2*N3=4
rem=$(( idx % (N2 * N3) ))       # rem = idx % 4
j=$(( rem / N3 ))                # will always be 0 since rem<4 and N3=4
k=$(( rem % N3 ))                # cycles through 0..3

downstream_task=${downstream_tasks[$i]}
evaluation_scheme=${evaluation_schemes[$j]}
model=${models[$k]}

# 4) Optimizer & Learning Rate
optimizer_spec="simple"
lr=0.003

echo "[$(date)] Combo #$idx: model=$model, task=$downstream_task, scheme=$evaluation_scheme"
echo "Logging to W&B project=${WANDB_PROJECT}"

# 5) Launch training
python wandb_downstream_evaluation.py \
  --model "$model" \
  --model_data_transform z-score \
  --downstream_task "$downstream_task" \
  --evaluation_scheme "$evaluation_scheme" \
  --optimizer_spec "$optimizer_spec" \
  --lr "$lr" \
  --mix_up 0.1 \
  --train_drop_rate 0.3 \
  --train_batch_size 64 \
  --train_accum_iter 1 \
  --train_epochs 100 \
  --train_warmup_epochs 10 \
  --finetune_batch_size 32 \
  --finetune_accum_iter 1 \
  --finetune_epochs 50 \
  --finetune_warmup_epochs 5 \
  --seed 3407 \
  --num_workers 0 \
  --pin_mem \
  --model_adaptation NA \
  --wandb_project "$WANDB_PROJECT"
