#!/bin/bash -l
#SBATCH --cluster xxx
#SBATCH --partition=xxx
#SBATCH --time=72:00:00
#SBATCH --account=xxx
#SBATCH --job-name="wandb_foundation_model_scale%a"
#SBATCH --array=0-35
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=16
#SBATCH --gpus-per-node=1
#SBATCH --mail-type=END,FAIL,TIME_LIMIT
#SBATCH --mail-user=xxx

#SBATCH --chdir=xxx
#SBATCH --output=./%x-%A_%a.out
#SBATCH --error=./%x-%A_%a.error

# 1) Activate conda environment


# === [1] Environment setup ===
export WANDB_ENTITY="xxx"
export WANDB_PROJECT="binocular_ssvep"
export WANDB_CACHE_DIR="xxx"

# === [2] Define grid ===
models=(eegpt labram biot bendr cbramod vit_small_patch16)
optimizer_specs=(finetune linear_prob)
downstream_tasks=(binocular_ssvep)
evaluation_schemes=(leave-one-out-finetuning population per-subject)

N1=${#models[@]}
N2=${#optimizer_specs[@]}
N3=${#downstream_tasks[@]}
N4=${#evaluation_schemes[@]}

# Map SLURM_ARRAY_TASK_ID → i, j, k, l
idx=$SLURM_ARRAY_TASK_ID
i=$(( idx / (N2 * N3 * N4) ))
rem1=$(( idx % (N2 * N3 * N4) ))
j=$(( rem1 / (N3 * N4) ))
rem2=$(( rem1 % (N3 * N4) ))
k=$(( rem2 / N4 ))
l=$(( rem2 % N4 ))

model=${models[$i]}
optimizer_spec=${optimizer_specs[$j]}
downstream_task=${downstream_tasks[$k]}
evaluation_scheme=${evaluation_schemes[$l]}

# === [3] Set learning rate ===
lr=0.005
[[ "$optimizer_spec" == "finetune" ]] && lr=0.0005

echo "[$(date)] Combo #$idx"
echo "  → model=$model, optimizer=$optimizer_spec, task=$downstream_task, scheme=$evaluation_scheme"
echo "Logging to W&B project=${WANDB_PROJECT}"

# === [4] Run training ===
python wandb_downstream_evaluation.py \
  --model "$model" \
  --model_data_transform z-score \
  --downstream_task "$downstream_task" \
  --evaluation_scheme "$evaluation_scheme" \
  --optimizer_spec "$optimizer_spec" \
  --lr "$lr" \
  --mix_up 0.2 \
  --train_drop_rate 0.1 \
  --train_batch_size 64 \
  --train_accum_iter 1 \
  --train_epochs 100 \
  --train_warmup_epochs 10 \
  --finetune_drop_rate 0.1 \
  --finetune_batch_size 32 \
  --finetune_accum_iter 1 \
  --finetune_epochs 50 \
  --finetune_warmup_epochs 5 \
  --seed 3407 \
  --num_workers 0 \
  --pin_mem \
  --model_adaptation NA \
  --wandb_project "$WANDB_PROJECT"