import numpy as np

class UnOrderedQueue:
    def __init__(self, act_dim, maxlen):
        self._act_dim = act_dim
        self._prob = np.ones((act_dim, )).astype(np.float32) / act_dim
        self.maxlen = maxlen
        self._indices = np.zeros((maxlen, ))
        self.l, self.r = 0, 0

    def _add(self, indice):
        if self.r < self.maxlen:
            self._indices[self.r] = indice
            self.r += 1
            return
        else:
            self._indices[self.l] = indice
            self.l = (self.l+1) % self.maxlen
            freq = np.bincount(self._indices.astype(np.int64), minlength=self._act_dim)
            new_prob = np.exp(-freq)
            new_prob = new_prob / new_prob.sum()
            self._prob = 0.99 * self._prob + 0.01 * new_prob
        return
