# $\mathsf{FlatLand}$: Personalized Federated Learning via Tailored Lorentz Space (Anonymous Repository)

## Requirement
- Python 3.10.12
- PyTorch 2.2.1
- PyTorch Geometric 2.5.2

## Run 
Following command lines run the experiments for our $\mathsf{FlatLand}$.
```sh
$ sh ./scripts/flatland.sh
$ sh ./scripts/fedavg.sh
```

- `gpus`: specify gpus to use
- `n-workers`: specify the number of workers on gpus, the actual number of workers will be max[n-workers, n-clients + 1]
- `model`: specify which model to use (fedavg, flatland), we will update the code of all baselines later
- `dataset`: specify the dataset
- `n-rnds`: specify the number of the round
- `n-eps`: specify the number of local epoch
- `n-clients`: specify the number of clients
- `optimizer`: the optimizer is Adam
- `lr`: specify the learning rate
- `csv`, `summary`: whether to store the procedure in csv file
- `wandb`: whether to use wandb
