# Compact Generalized Non-local Network in Caffe

The implementation of Compact Generalized Non-local (CGNL) Module in Caffe for multiple computer vision tasks.

![introfig](img/intro.png)

> Generated by [Netscope](http://ethereon.github.io/netscope/)

### Notes:

The reason why I update to add the Caffe prototxt is that I implement this method into my recent training tasks and it works well. There are subtle differences between the PyTorch implementation and this simple Caffe re-implementation. This re-implementation is just an example for the proof of the concept. So it is not intended to reproduce the results reported in PyTorch implementation. The Non-local (NL) network in Caffe can be also build easily following the CGNL prototxt.

## Getting Start

### Prepare Caffe

Follow the official [instruction](https://caffe.berkeleyvision.org/installation.html) to prepare the Caffe with successful compilation. Here we use `CAFEE_ROOT` to indicate the Caffe repo directory.

### Add Layers

- Copy `source` layers:

```bash
cp caffe/src/caffe/layers/* ${CAFFE_ROOT}/src/caffe/layers/
```

- Copy `include` layers:

```bash
cp caffe/include/caffe/layers/* ${CAFFE_ROOT}/include/caffe/layers/
```

- Add the following lines of code into `${CAFFE_ROOT}/src/caffe/proto/caffe.proto`:

```cpp
message LayerParameter {
    // Use the next available layer-specific ID in your Caffe.
    optional PermuteParameter permute_param = 149; 
}

message PermuteParameter {
    // The new orders of the axes of data. Notice it should be with
    // in the same range as the input data, and it starts from 0.
    // Do not provide repeated order.
    repeated uint32 order = 1;
}
```

## Reference

[Permute Layer in SSD](https://github.com/BVLC/caffe/issues/3594#issuecomment-188804857) and [Matrix Multiplication Layer](https://github.com/simbaforrest/caffe/blob/master/src/caffe/layers/matrix_multiplication_layer.cpp).
