#!/usr/bin/env bash

GPU=5

CLIENT_NUM=10

WORKER_NUM=4

BATCH_SIZE=32

INCREMENTAL_STAGE=3

ALPHA=1

MEMORY_SIZE=300

DATASET=office31

MODEL=resnet18

INCREMENTAL_ROUND=180

ROUND=540

CLIENT_OPTIMIZER=adam

EPOCH=20

EPOCH_PERSONAL=40

LR=0.01

LR_P=0.01


BASELINE="FDIL"



python3 main.py \
--gpu $GPU \
--dataset $DATASET \
--model $MODEL \
--alpha $ALPHA  \
--client_num_in_total $CLIENT_NUM \
--client_num_per_round $WORKER_NUM \
--comm_round $ROUND \
--epochs $EPOCH \
--epochs_personal $EPOCH_PERSONAL \
--client_optimizer $CLIENT_OPTIMIZER \
--batch_size $BATCH_SIZE \
--lr $LR \
--lr_p $LR_P \
--incremental_stage $INCREMENTAL_STAGE \
--incremental_round $INCREMENTAL_ROUND \
--memory_size $MEMORY_SIZE \
--baseline $BASELINE \

