import torch.nn as nn

class network(nn.Module):
#全连接层是深度学习模型中常用的一种层类型，用于将输入数据的特征映射到输出类别的预测结果。它包括一个或多个线性变换（即矩阵乘法）和非线性激活函数。全连接层中的参数（权重和偏置）会被训练以适应特定的任务。
    def __init__(self, numclass, feature_extractor):#这段代码定义了一个带有特征提取器和分类器的网络类network的构造函数。特征提取器用于从输入数据中提取特征表示，而分类器用于将提取到的特征进行分类预测。
        super(network, self).__init__()
        self.feature = feature_extractor#特征提取器通常是一个预训练的卷积神经网络模型，用于从输入数据中提取有意义的特征表示。它通常由多个卷积层、池化层和全连接层组成，可以通过前向传播将输入数据转换为更高级别的特征表示。
        self.fc = nn.Linear(feature_extractor.fc.in_features, numclass, bias=True)#接下来，创建一个全连接层（nn.Linear）作为分类器，命名为self.fc。该全连接层的输入维度为feature_extractor.fc.in_features，即feature_extractor中最后一层全连接层的输入特征数量。输出维度为numclass，表示分类器的输出类别数量。

    def forward(self, input):#network类中的前向传播方法forward，用于定义数据在网络中的正向传播过程。
        x = self.feature(input)#首先，将输入input传递给特征提取器self.feature，得到特征表示x。这里假设self.feature是一个包含卷积层和全连接层的模型，通过调用self.feature(input)可以将输入数据传递到特征提取器中，得到对应的特征表示。
        x = self.fc(x)#接着，将特征表示x传递给分类器self.fc，通过调用self.fc(x)进行分类预测。全连接层会将特征表示映射到类别数量的输出维度上。
        return x
#将新的类别添加到现有的模型中而不会影响先前学习的类别。这样可以在不重新训练整个网络的情况下，对新类别进行分类预测，保留了先前学习的知识。
    def Incremental_learning(self, numclass):
        weight = self.fc.weight.data#将当前分类器（全连接层）的权重（self.fc.weight.data）和偏置（self.fc.bias.data）保存到变量weight和bias中。
        bias = self.fc.bias.data
        in_feature = self.fc.in_features#接着，获取当前分类器的输入特征数量（in_feature）和输出类别数量（out_feature）。
        out_feature = self.fc.out_features

        self.fc = nn.Linear(in_feature, numclass, bias=True)#然后，重新定义分类器self.fc为一个新的全连接层，输入特征数量为in_feature，输出类别数量为numclass（增量学习后的新类别数量），同时启用偏置项。
        self.fc.weight.data[:out_feature] = weight#接下来，将先前保存的权重和偏置重新分配给新的分类器，以保留先前学习的知识。
        self.fc.bias.data[:out_feature] = bias

    def feature_extractor(self, inputs):#特征提取器，卷积池化那些，获得向量等数据
        return self.feature(inputs)
#可以方便地对输入的特征进行预测操作，获得模型对输入数据的分类预测结果。这个方法可以在应用中用于进行模型推断或评估，根据输入特征进行分类预测。
    def predict(self, fea_input):
        return self.fc(fea_input)

#用于进行图像分类任务。输入图像经过卷积层和激活函数提取特征后，通过全连接层进行分类预测
class LeNet(nn.Module):
    def __init__(self, channel=3, hideen=768, num_classes=10):
        super(LeNet, self).__init__()
        act = nn.Sigmoid#定义了一个变量act，它是一个激活函数，此处选择使用nn.Sigmoid作为激活函数。
        self.body = nn.Sequential(
            nn.Conv2d(channel, 12, kernel_size=5, padding=5 // 2, stride=2),
            act(),#
            nn.Conv2d(12, 12, kernel_size=5, padding=5 // 2, stride=2),
            act(),
            nn.Conv2d(12, 12, kernel_size=5, padding=5 // 2, stride=1),
            act(),
        )
        self.fc = nn.Sequential(
            nn.Linear(hideen, num_classes)
        )

    def forward(self, x):

        out = self.body(x)
  
        out = out.view(out.size(0), -1)
        out = self.fc(out)
        return out


def weights_init(m):
    try:
        if hasattr(m, "weight"):#首先，通过 hasattr(m, "weight") 来检查模块 m 是否具有 weight 属性，即是否存在权重参数。
            m.weight.data.uniform_(-0.5, 0.5)#如果存在权重参数，则使用 m.weight.data.uniform_(-0.5, 0.5) 对权重进行均匀分布的初始化。这里使用了均匀分布的随机数，范围在 -0.5 到 0.5 之间。
    except Exception:
        print('warning: failed in weights_init for %s.weight' % m._get_name())#在每个 try 块内部，使用 data 属性来访问参数的值，并对其进行初始化。
    try:
        if hasattr(m, "bias"):
            m.bias.data.uniform_(-0.5, 0.5)
    except Exception:
        print('warning: failed in weights_init for %s.bias' % m._get_name())#如果在初始化过程中出现异常，会捕获异常并打印相应的警告信息，以便提示哪些参数初始化失败。
