import numpy as np
from PIL import Image
import cv2
import os
import pandas as pd

class Proxy_Data():#在构造函数中，将传递的test_transform参数赋值给对象的test_transform属性。然后，初始化TestData和TestLabels两个列表，用于存储测试数据和测试标签。
    def __init__(self, test_transform=None):
        super(Proxy_Data, self).__init__()
        self.test_transform = test_transform
        self.TestData = []
        self.TestLabels = []

    def concatenate(self, datas, labels):
        con_data = datas[0]
        con_label = labels[0]
        for i in range(1, len(datas)):
            con_data = np.concatenate((con_data, datas[i]), axis=0)
            con_label = np.concatenate((con_label,labels[i]), axis=0)
        return con_data, con_label#循环结束后，返回最终连接后的数据数组con_data和标签数组con_label。

    def getTestData(self, new_set, new_set_label):
        datas, labels = [], []
        self.TestData, self.TestLabels = [], []
        if len(new_set) != 0 and len(new_set_label) != 0:
            datas = [exemplar for exemplar in new_set]
            for i in range(len(new_set)):
                length = len(datas[i])
                labels.append(np.full((length), new_set_label[i]))

        self.TestData, self.TestLabels = self.concatenate(datas, labels)

    def getTestItem(self, index):#通过调用这个方法，可以根据指定索引获取测试数据集中的单个数据项，并可选择性地对图像数据进行转换操作。返回的结果是转换后的图像数据和对应的标签，可以在后续的代码中使用。
        img, target = Image.fromarray(self.TestData[index]), self.TestLabels[index]

        if self.test_transform:#接下来，通过条件判断语句检查是否存在test_transform属性，即是否定义了测试数据的转换操作。
            img = self.test_transform(img)#如果存在test_transform，则将获取到的图像对象img作为输入，应用self.test_transform所定义的转换操作，将图像进行相应的转换。

        return img, target#最后，将转换后的图像数据img和对应的标签target作为结果进行返回。

    def __getitem__(self, index):
        if self.TestData != []:#如果TestData不为空，说明测试数据已经被加载到类中，那么调用类的getTestItem方法，将索引值index作为参数传递给getTestItem方法，从测试数据集中获取指定索引位置的数据项。
            return self.getTestItem(index)

    def __len__(self):#返回类的实例对象的长度,测试数据集的长度
        if self.TestData != []:
            return len(self.TestData)


