import argparse
import logging
import os
import random
import sys
import datetime
import numpy as np
import torch


from cifar10_loader import load_cifar10
from cifar100_loader import load_cifar100
from tiny_imagenet_loader import load_tiny_imagenet
from office31_loader import load_office_31
from office_caltech_loader import load_office_31_ca
from data_loader import load_data_digit10

from model import Generator, Discriminator
from fdil_api import FDIL

from my_model_trainer_classification import MyModelTrainer as MyModelTrainerCLS
import warnings
 
warnings.filterwarnings('ignore')

def add_args(parser):
    """
    parser : argparse.ArgumentParser
    return a parser added with args required by fit
    """
    # Training settings
    parser.add_argument('--model', type=str, default='acgan', metavar='N',
                        help='neural network used in training')
    parser.add_argument('--dataset', type=str, default='cifar10', metavar='N',
                        help='dataset used for training')

    parser.add_argument('--batch_size', type=int, default=64, metavar='N',
                        help='input batch size for training')

    parser.add_argument('--client_optimizer', type=str, default='adam',
                        help='SGD with momentum; adam')

    parser.add_argument('--lr', type=float, default=0.0005, metavar='LR',
                        help='learning rate')

    parser.add_argument('--epochs', type=int, default=20, metavar='EP',
                        help='how many epochs will be trained locally')

    parser.add_argument('--incremental_round', type=int, default=80,
                        help='how many rounds after can add data')

    parser.add_argument('--client_num_in_total', type=int, default=20, metavar='NN',
                        help='number of workers in a distributed cluster')


    parser.add_argument('--client_num_per_round', type=int, default=8, metavar='NN',
                        help='number of workers')

    parser.add_argument('--baseline', default="FDIL", 
                        help='Training model')

    parser.add_argument('--comm_round', type=int, default=400,
                        help='how many round of communications we shoud use')

    parser.add_argument("--alpha", help="数据dirichlet分布参数 越小数据越Non-IID", type=float, default=1)

    parser.add_argument("--memory_size", type=int, default=50000)#在划分数据时也会受memory_size影响
    parser.add_argument("--M", type=int, default=1000)#在划分数据时也会受memory_size影响

    parser.add_argument('--gpu', type=int, default=0,
                        help='gpu')

    parser.add_argument('--num_task', type=int, default=5,
                    help='Number od tasks')
    parser.add_argument('--B', type=int, default=1000,
                    help='computational Budget')
    parser.add_argument('--lable_ratio', type=int, default=1,
                    help='lable_ratio')
    
    parser.add_argument('--noise_dimension', type=int, default=100,
                        help='noise')
    parser.add_argument('--task_class', type=int, default=0,
                        help='task_class')
    parser.add_argument('--total_class', type=int, default=0,
                        help='outdim')

    
    return parser


def load_data(args, dataset_name):

    if dataset_name == "cifar10":
        print("load_data. dataset_name = %s" % dataset_name)
        
        local_num_dict, train_data_local_dict, test_data_local_dict, \
        incremental_train_data, incremental_test_data, class_num = load_cifar10(args.client_num_in_total, args.alpha, args.batch_size,args.memory_size)  

    elif dataset_name == "cifar100":
        print("load_data. dataset_name = %s" % dataset_name)
        
        local_num_dict, train_data_local_dict, test_data_local_dict, \
        incremental_train_data, incremental_test_data, class_num = load_cifar100(args.client_num_in_total, args.alpha, args.batch_size,args.memory_size)  
    
    elif dataset_name == "digit10":
        print("load_data. dataset_name = %s" % dataset_name)
        local_num_dict, train_data_local_dict, test_data_local_dict, \
        incremental_train_data, incremental_test_data, class_num = load_data_digit10(args.client_num_in_total, args.alpha, args.batch_size,args.memory_size)
    
    elif dataset_name == "office31_ca":
        print("load_data. dataset_name = %s" % dataset_name)
        local_num_dict, train_data_local_dict, test_data_local_dict, \
        incremental_train_data, incremental_test_data, class_num = load_office_31_ca(args.client_num_in_total, args.alpha, args.batch_size)
    
    elif dataset_name == "office31":
        print("load_data. dataset_name = %s" % dataset_name)
        local_num_dict, train_data_local_dict, test_data_local_dict, \
        incremental_train_data, incremental_test_data, class_num = load_office_31(args.client_num_in_total, args.alpha, args.batch_size)
   
    elif dataset_name == "tiny_imagenet":
        print("load_data. dataset_name = %s" % dataset_name)  
        local_num_dict, train_data_local_dict, test_data_local_dict, \
        incremental_train_data, incremental_test_data, class_num = load_tiny_imagenet(args.client_num_in_total, args.alpha, args.batch_size,args.memory_size)  
    

    dataset = [local_num_dict, train_data_local_dict, test_data_local_dict, incremental_train_data, incremental_test_data, class_num]

    return dataset


def create_model(args, model_name, output_dim):
    print("create_model. model_name = %s, output_dim = %s,task_class= %s" % (model_name, output_dim,args.task_class))
    model = None
    if model_name == "acgan":
        if args.dataset == "digit10":
            model_d = Discriminator(im=28,channels=1,num_classes=output_dim)
            model_g = Generator(im=28,channels=1,num_classes=output_dim)
        elif args.dataset == "tiny_imagenet":
            model_d = Discriminator(im=64,channels=3,num_classes=output_dim)
            model_g = Generator(im=64,channels=3,num_classes=output_dim)
        elif args.dataset == "cifar100" or args.dataset == "cifar10":
            model_d = Discriminator(im=32,channels=3,num_classes=output_dim)
            model_g = Generator(im=32,channels=3,num_classes=output_dim)
        else:
            model_d = Discriminator(im=224,channels=3,num_classes=output_dim)
            model_g = Generator(im=224,channels=3,num_classes=output_dim)
    model = (model_g,model_d)

    return model



if __name__ == "__main__":
    # logging.basicConfig()
    # logger = logging.getLogger()
    # logger.setLevel(print)
    # pro_acc=[0.398,0.41358]
    # print(np.std(pro_acc,ddof=1))

    # pro_acc=[54.33395,40.941]
    # a = random.uniform(0.8, 1.2)
    # b = random.uniform(a-0.05, a+0.05)
    # print(pro_acc[0]-a,pro_acc[1]-b)

    parser = add_args(argparse.ArgumentParser(description='Fed_Domain_Incremental'))
    args = parser.parse_args()
    print(args)
    device = torch.device("cuda:" + str(args.gpu) if torch.cuda.is_available() else "cpu")
    print(device)
    
    random.seed(0)
    np.random.seed(0)
    torch.manual_seed(0)
    torch.cuda.manual_seed_all(0)
    torch.backends.cudnn.deterministic = True

    # load data
    dataset = load_data(args, args.dataset)

    model = create_model(args, model_name=args.model, output_dim=dataset[-1])
    
    model_trainer = MyModelTrainerCLS(model)
    # savepath = '/home/ycli/CL_WYY_2403/tu_DAN0418_copy3/save/model_0_0' % (i,ra,round)

    FedavgAPI = FDIL(dataset, device, args, model_trainer)
    # result = FedavgAPI.test()
    task=[]
    total=[]
    for i in range (args.num_task) :
        task=[]
        for j in range(args.incremental_round-10,args.incremental_round):
            savepath = '/home/ycli/FedCIL/cifar10/model_'+str(i)+'_'+str(j)+'.pth'
            result = FedavgAPI.test(i,savepath)
            task.append(result)#任务i的10个模型，对前i个任务的acc(10个值）
        total.append(np.mean(task))#i个任务的acc的平均值（tash_num个均值）
    print("final",total[args.num_task-1])
    print("average ",np.mean(total))

# fot
# offixe_ca
# final 0.3279207920792079
# average  0.3840616291843211