#!/usr/bin/env bash

GPU=6

NOISE=100

CLIENT_NUM=20

WORKER_NUM=8

BATCH_SIZE=64

INCREMENTAL_STAGE=5

ALPHA=1

M=1000

MEMORY_SIZE=1000

DATASET=cifar10

MODEL=acgan

INCREMENTAL_ROUND=1

ROUND=30

CLIENT_OPTIMIZER=adam

EPOCH=20

EPOCH_PERSONAL=40

LR=0.0001

LR_P=0.0001

LAMBDA=0.8

BASELINE="FDIL"



python3 main.py \
--gpu $GPU \
--dataset $DATASET \
--model $MODEL \
--alpha $ALPHA  \
--client_num_in_total $CLIENT_NUM \
--client_num_per_round $WORKER_NUM \
--comm_round $ROUND \
--epochs $EPOCH \
--lambda_p $LAMBDA \
--epochs_personal $EPOCH_PERSONAL \
--client_optimizer $CLIENT_OPTIMIZER \
--batch_size $BATCH_SIZE \
--lr $LR \
--lr_p $LR_P \
--incremental_stage $INCREMENTAL_STAGE \
--incremental_round $INCREMENTAL_ROUND \
--memory_size $MEMORY_SIZE \
--baseline $BASELINE \
--noise_dimension $NOISE \
--M $M \

