from collections import namedtuple
from typing import Tuple

from acdc.acdc_utils import TorchIndex
from acdc.TLACDCEdge import EdgeType

CircuitEdge = Tuple[
    str, TorchIndex, str, TorchIndex
]  # (out_node_name, out_shape, in_node_name, in_shape)
# In the code: CircuitEdge is more like Tuple[str, TorchIndex, str, TorchIndex] (unpacked version of above)

Circuit = Tuple[Tuple[CircuitEdge, EdgeType]]  # (edge, unsure?)


CircuitSaveData = namedtuple("CircuitData", ["circuits", "scores", "diffs"])
