"""
Usage:
python -m 50_app_batch_optuna_nosys
"""

import subprocess
import yaml
import os

# ============================== #
model_lst = [
    # "gemini",
    "gpt4o",
    # "sonnet",
]
dataset_name = [
    # "sys_aqua",
    # "sys_bbh_boolean_expressions",
    # "sys_bbh_causal_judgement",
    # "sys_gsm8k",
    # "sys_mmlu_college_medicine_test",
    # "sys_mmlu_high_school_us_history_test",
    # "sys_mmlu_high_school_world_history_test",
    "sys_mmlu_professional_law_test",
]
experiment_name = [ds_n + "_nosys_psaooptuna" for ds_n in dataset_name]
experiment_description = [
    f"{ds_n} experiment with no system prompt psaooptuna" for ds_n in dataset_name
]
sys_prompt_dict = {
    "gsm8k_1": "You are a math tutor for grade school students answering GSM8K math word problems. Carefully read each question, identify relevant quantities, and use appropriate arithmetic operations. Provide clear, step-by-step explanations using simple language, solving the problem independently. Always justify your reasoning and do not round numbers unless the question asks; use exact values. Finish by clearly stating the final answer derived from your calculations.",
    "gsm8k_2": "You are a math tutor for grade school students answering GSM8K math word problems. Carefully read each question, identify relevant quantities, and use appropriate arithmetic operations. Provide clear, step-by-step explanations using simple language, solving the problem independently. Always justify your reasoning and do not round numbers unless the question asks; use exact values. Finish by clearly stating the final answer derived from your calculations.",
    "gsm8k_3": "You are a math tutor for grade school students answering GSM8K math word problems. Carefully read each question, identify relevant quantities, and use appropriate arithmetic operations. Provide clear, step-by-step explanations using simple language, solving the problem independently. Always justify your reasoning and do not round numbers unless the question asks; use exact values. Finish by clearly stating the final answer derived from your calculations.",
    "gsm8k_4": "You are a math tutor for grade school students answering GSM8K math word problems. Carefully read each question, identify relevant quantities, and use appropriate arithmetic operations. Provide clear, step-by-step explanations using simple language, solving the problem independently. Always justify your reasoning and do not round numbers unless the question asks; use exact values. Finish by clearly stating the final answer derived from your calculations.",
    "aqua": "You will be given an AQUA algebraic word problem that requires a detailed, step-by-step solution. Clearly identify the relevant mathematical relationships and use appropriate algebraic techniques. Show all your intermediate reasoning steps and explain how each step addresses the problem. Link your calculations directly to the original question, ensuring every step is justified with provided information. Always check that your answer is mathematically accurate and directly responds to the question.",
    "bbh_boolean_expressions": "You will be presented with a single, challenging question from the BBH (Big-Bench Hard) dataset, which covers a wide range of topics including logic, mathematics, language understanding, and complex problem-solving. These questions are designed to test advanced reasoning skills, so pay close attention to all details, requirements, and constraints in the prompt. Carefully analyze the problem, applying relevant background knowledge and working through the solution step by step. Justify each part of your reasoning and explain the methods or concepts you use to reach your answer, focusing on information directly needed to solve the problem. Restrict your explanation to the essential logic and details, leaving out unrelated commentary, so your solution remains clear and easy to follow.",
    "bbh_causal_judgement": "You will be presented with a single, challenging question from the BBH (Big-Bench Hard) dataset, which covers a wide range of topics including logic, mathematics, language understanding, and complex problem-solving. These questions are designed to test advanced reasoning skills, so pay close attention to all details, requirements, and constraints in the prompt. Carefully analyze the problem, applying relevant background knowledge and working through the solution step by step. Justify each part of your reasoning and explain the methods or concepts you use to reach your answer, focusing on information directly needed to solve the problem. Restrict your explanation to the essential logic and details, leaving out unrelated commentary, so your solution remains clear and easy to follow.",
    "bbh_movie_recommendation": "You will be presented with a single, challenging question from the BBH (Big-Bench Hard) dataset, which covers a wide range of topics including logic, mathematics, language understanding, and complex problem-solving. These questions are designed to test advanced reasoning skills, so pay close attention to all details, requirements, and constraints in the prompt. Carefully analyze the problem, applying relevant background knowledge and working through the solution step by step. Justify each part of your reasoning and explain the methods or concepts you use to reach your answer, focusing on information directly needed to solve the problem. Restrict your explanation to the essential logic and details, leaving out unrelated commentary, so your solution remains clear and easy to follow.",
    "bbh_ruin_names": "You will be presented with a single, challenging question from the BBH (Big-Bench Hard) dataset, which covers a wide range of topics including logic, mathematics, language understanding, and complex problem-solving. These questions are designed to test advanced reasoning skills, so pay close attention to all details, requirements, and constraints in the prompt. Carefully analyze the problem, applying relevant background knowledge and working through the solution step by step. Justify each part of your reasoning and explain the methods or concepts you use to reach your answer, focusing on information directly needed to solve the problem. Restrict your explanation to the essential logic and details, leaving out unrelated commentary, so your solution remains clear and easy to follow.",
    "bbh_temporal_sequences": "You will be presented with a single, challenging question from the BBH (Big-Bench Hard) dataset, which covers a wide range of topics including logic, mathematics, language understanding, and complex problem-solving. These questions are designed to test advanced reasoning skills, so pay close attention to all details, requirements, and constraints in the prompt. Carefully analyze the problem, applying relevant background knowledge and working through the solution step by step. Justify each part of your reasoning and explain the methods or concepts you use to reach your answer, focusing on information directly needed to solve the problem. Restrict your explanation to the essential logic and details, leaving out unrelated commentary, so your solution remains clear and easy to follow.",
    "mmlu_college_medicine_test": "You will be given a question from the MMLU dataset, covering subjects such as STEM, humanities, or social sciences. Carefully read each question and identify the relevant concepts and facts required to solve it. Answer the question directly and accurately using your subject knowledge. Briefly explain your reasoning and reference any essential evidence or logic. Keep your response concise, avoiding unnecessary information or details.",
    "mmlu_high_school_us_history_test": "You will be given a question from the MMLU dataset, covering subjects such as STEM, humanities, or social sciences. Carefully read each question and identify the relevant concepts and facts required to solve it. Answer the question directly and accurately using your subject knowledge. Briefly explain your reasoning and reference any essential evidence or logic. Keep your response concise, avoiding unnecessary information or details.",
    "mmlu_high_school_world_history_test": "You will be given a question from the MMLU dataset, covering subjects such as STEM, humanities, or social sciences. Carefully read each question and identify the relevant concepts and facts required to solve it. Answer the question directly and accurately using your subject knowledge. Briefly explain your reasoning and reference any essential evidence or logic. Keep your response concise, avoiding unnecessary information or details.",
    "mmlu_professional_law_test": "You will be given a question from the MMLU dataset, covering subjects such as STEM, humanities, or social sciences. Carefully read each question and identify the relevant concepts and facts required to solve it. Answer the question directly and accurately using your subject knowledge. Briefly explain your reasoning and reference any essential evidence or logic. Keep your response concise, avoiding unnecessary information or details.",
    "multiarith": "You will receive a math word problem from the MultiArith dataset, appropriate for elementary-level reasoning. Read the problem carefully, identify relevant quantities, and determine the necessary arithmetic operations. Break the problem into logical steps using addition, subtraction, multiplication, or division as needed. Show all intermediate steps in your explanation and justify each calculation clearly. Focus on providing a detailed, step-by-step solution with exact answers, avoiding unnecessary details.",
}

# ============================== #


def run_app(
    config,
    model,
    exp_name,
    exp_desc,
    dataset_name,
    sys_prompt,
    result_path,
):
    config["experiment"]["name"] = exp_name
    config["experiment"]["description"] = exp_desc
    config["components"]["task"]["question_answer_psao_optuna"][
        "dataset_name"
    ] = dataset_name
    config["components"]["task"]["question_answer_psao_optuna"]["id_lst"] = [1]
    config["components"]["task"]["question_answer_psao_optuna"][
        "data_path"
    ] = "/Users/anjin.liu/Documents/GitHub/prompt_optimisation_dataset/selected_50/no_sys"
    config["components"]["task"]["question_answer_psao_optuna"]["prompt_msg_template"][
        0
    ]["content"] = sys_prompt

    config["output"]["results_dataframe"] = result_path
    config["config_anchors"] = None

    yaml_path = f"config/experiments/{model}/{dataset_name}_nosys_psaooptuna.yaml"
    with open(yaml_path, "w") as out_f:
        yaml.dump(config, out_f)

    print(f"Running experiment for dataset: {dataset_name}")
    cmd = [
        "python",
        "app.py",
        "--config",
        f"{model}/{dataset_name}_nosys_psaooptuna.yaml",
        "--quiet",
    ]
    subprocess.run(cmd, check=True)
    if os.path.exists(yaml_path):
        os.remove(yaml_path)


# ============================== #


if __name__ == "__main__":

    for _model in model_lst:

        print(_model)

        with open(f"config/experiments/{_model}/psaooptuna_nosys.yaml", "r") as f:
            config_base = yaml.safe_load(f)

        for i in range(1, 11):

            results_path = [
                f"result/50_psao_optuna_nosys_{i}/{ds_n}_nosys_psaooptuna_{_model}.csv"
                for ds_n in dataset_name
            ]

            for _idx in range(len(dataset_name)):

                run_app(
                    config_base,
                    _model,
                    exp_name=experiment_name[_idx],
                    exp_desc=experiment_description[_idx],
                    dataset_name=dataset_name[_idx],
                    sys_prompt=None,
                    result_path=results_path[_idx],
                )
