"""
Usage:
python -m app_batch_optuna_50q_nosys
"""

import subprocess
import yaml
import os

# ============================== #
model_lst = [
    # "gemini",
    "gpt4o",
    # "sonnet",
]
dataset_name = [
    "no_sys_aqua",
    "no_sys_bbh_causal_judgement",
    "no_sys_gsm8k",
    "no_sys_mmlu_college_medicine_test",
    "no_sys_mmlu_high_school_us_history_test",
    "no_sys_mmlu_high_school_world_history_test",
    "no_sys_mmlu_professional_law_test",
]
experiment_name = [ds_n + "_nosys_psaooptuna" for ds_n in dataset_name]
experiment_description = [
    f"{ds_n} experiment with no system prompt psaooptuna" for ds_n in dataset_name
]


# ============================== #


def run_app(
    config,
    model,
    exp_name,
    exp_desc,
    dataset_name,
    sys_prompt,
    result_path,
):
    config["experiment"]["name"] = exp_name
    config["experiment"]["description"] = exp_desc
    config["components"]["task"]["question_answer_psao_optuna"][
        "dataset_name"
    ] = dataset_name
    config["components"]["task"]["question_answer_psao_optuna"]["id_lst"] = []
    config["components"]["task"]["question_answer_psao_optuna"][
        "data_path"
    ] = "/Users/anjin.liu/Documents/GitHub/prompt_optimisation_dataset/selected_50/no_sys"
    config["components"]["task"]["question_answer_psao_optuna"]["optuna_db_name"] = (
        dataset_name + "_optuna.db"
    )
    config["components"]["task"]["question_answer_psao_optuna"][
        "optuna_study_name"
    ] = dataset_name
    config["output"]["results_dataframe"] = result_path
    config["config_anchors"] = None

    yaml_path = f"config/experiments/{model}/{dataset_name}_nosys_psaooptuna.yaml"
    with open(yaml_path, "w") as out_f:
        yaml.dump(config, out_f)

    print(f"Running experiment for dataset: {dataset_name}")
    cmd = [
        "python",
        "app.py",
        "--config",
        f"{model}/{dataset_name}_nosys_psaooptuna.yaml",
        "--quiet",
    ]
    subprocess.run(cmd, check=True)
    if os.path.exists(yaml_path):
        os.remove(yaml_path)


# ============================== #


if __name__ == "__main__":

    for _model in model_lst:

        print(_model)

        with open(f"config/experiments/{_model}/psaooptuna_nosys.yaml", "r") as f:
            config_base = yaml.safe_load(f)

        for i in range(1):

            results_path = [
                f"result/50_psao_optuna_nosys/{ds_n}_nosys_psaooptuna_{_model}.csv"
                for ds_n in dataset_name
            ]

            for _idx in range(len(dataset_name)):

                run_app(
                    config_base,
                    _model,
                    exp_name=experiment_name[_idx],
                    exp_desc=experiment_description[_idx],
                    dataset_name=dataset_name[_idx],
                    sys_prompt=None,
                    result_path=results_path[_idx],
                )
