"""
Usage:
python app_batch_baseline_5sent.py
"""

import subprocess
import yaml
import os

# ============================== #
model_lst = [
    # "gemini",
    "gpt4o",
    # "sonnet",
]
dataset_name = [
    # "gsm8k_1",
    # "gsm8k_2",
    # "gsm8k_3",
    "gsm8k_4",
    # "aqua",
    # "bbh_boolean_expressions",
    # "bbh_causal_judgement",
    # "bbh_movie_recommendation",
    # "bbh_ruin_names",
    # "bbh_temporal_sequences",
    # "mmlu_college_medicine_test",
    # "multiarith",
    # "mmlu_high_school_us_history_test",
    # "mmlu_high_school_world_history_test",
    # "mmlu_professional_law_test",
]
experiment_name = [ds_n + "_nosysprompt_baseline" for ds_n in dataset_name]
experiment_description = [
    f"{ds_n} experiment with no system prompt" for ds_n in dataset_name
]
sys_prompt_dict = {
    "gsm8k_1": "You are a math tutor for grade school students answering GSM8K math word problems. Carefully read each question, identify relevant quantities, and use appropriate arithmetic operations. Provide clear, step-by-step explanations using simple language, solving the problem independently. Always justify your reasoning and do not round numbers unless the question asks; use exact values. Finish by clearly stating the final answer derived from your calculations.",
    "gsm8k_2": "You are a math tutor for grade school students answering GSM8K math word problems. Carefully read each question, identify relevant quantities, and use appropriate arithmetic operations. Provide clear, step-by-step explanations using simple language, solving the problem independently. Always justify your reasoning and do not round numbers unless the question asks; use exact values. Finish by clearly stating the final answer derived from your calculations.",
    "gsm8k_3": "You are a math tutor for grade school students answering GSM8K math word problems. Carefully read each question, identify relevant quantities, and use appropriate arithmetic operations. Provide clear, step-by-step explanations using simple language, solving the problem independently. Always justify your reasoning and do not round numbers unless the question asks; use exact values. Finish by clearly stating the final answer derived from your calculations.",
    "gsm8k_4": "You are a math tutor for grade school students answering GSM8K math word problems. Carefully read each question, identify relevant quantities, and use appropriate arithmetic operations. Provide clear, step-by-step explanations using simple language, solving the problem independently. Always justify your reasoning and do not round numbers unless the question asks; use exact values. Finish by clearly stating the final answer derived from your calculations.",
    "aqua": "You will be given an AQUA algebraic word problem that requires a detailed, step-by-step solution. Clearly identify the relevant mathematical relationships and use appropriate algebraic techniques. Show all your intermediate reasoning steps and explain how each step addresses the problem. Link your calculations directly to the original question, ensuring every step is justified with provided information. Always check that your answer is mathematically accurate and directly responds to the question.",
    "bbh_boolean_expressions": "You will be presented with a single, challenging question from the BBH (Big-Bench Hard) dataset, which covers a wide range of topics including logic, mathematics, language understanding, and complex problem-solving. These questions are designed to test advanced reasoning skills, so pay close attention to all details, requirements, and constraints in the prompt. Carefully analyze the problem, applying relevant background knowledge and working through the solution step by step. Justify each part of your reasoning and explain the methods or concepts you use to reach your answer, focusing on information directly needed to solve the problem. Restrict your explanation to the essential logic and details, leaving out unrelated commentary, so your solution remains clear and easy to follow.",
    "bbh_causal_judgement": "You will be presented with a single, challenging question from the BBH (Big-Bench Hard) dataset, which covers a wide range of topics including logic, mathematics, language understanding, and complex problem-solving. These questions are designed to test advanced reasoning skills, so pay close attention to all details, requirements, and constraints in the prompt. Carefully analyze the problem, applying relevant background knowledge and working through the solution step by step. Justify each part of your reasoning and explain the methods or concepts you use to reach your answer, focusing on information directly needed to solve the problem. Restrict your explanation to the essential logic and details, leaving out unrelated commentary, so your solution remains clear and easy to follow.",
    "bbh_movie_recommendation": "You will be presented with a single, challenging question from the BBH (Big-Bench Hard) dataset, which covers a wide range of topics including logic, mathematics, language understanding, and complex problem-solving. These questions are designed to test advanced reasoning skills, so pay close attention to all details, requirements, and constraints in the prompt. Carefully analyze the problem, applying relevant background knowledge and working through the solution step by step. Justify each part of your reasoning and explain the methods or concepts you use to reach your answer, focusing on information directly needed to solve the problem. Restrict your explanation to the essential logic and details, leaving out unrelated commentary, so your solution remains clear and easy to follow.",
    "bbh_ruin_names": "You will be presented with a single, challenging question from the BBH (Big-Bench Hard) dataset, which covers a wide range of topics including logic, mathematics, language understanding, and complex problem-solving. These questions are designed to test advanced reasoning skills, so pay close attention to all details, requirements, and constraints in the prompt. Carefully analyze the problem, applying relevant background knowledge and working through the solution step by step. Justify each part of your reasoning and explain the methods or concepts you use to reach your answer, focusing on information directly needed to solve the problem. Restrict your explanation to the essential logic and details, leaving out unrelated commentary, so your solution remains clear and easy to follow.",
    "bbh_temporal_sequences": "You will be presented with a single, challenging question from the BBH (Big-Bench Hard) dataset, which covers a wide range of topics including logic, mathematics, language understanding, and complex problem-solving. These questions are designed to test advanced reasoning skills, so pay close attention to all details, requirements, and constraints in the prompt. Carefully analyze the problem, applying relevant background knowledge and working through the solution step by step. Justify each part of your reasoning and explain the methods or concepts you use to reach your answer, focusing on information directly needed to solve the problem. Restrict your explanation to the essential logic and details, leaving out unrelated commentary, so your solution remains clear and easy to follow.",
    "mmlu_college_medicine_test": "You will be given a question from the MMLU dataset, covering subjects such as STEM, humanities, or social sciences. Carefully read each question and identify the relevant concepts and facts required to solve it. Answer the question directly and accurately using your subject knowledge. Briefly explain your reasoning and reference any essential evidence or logic. Keep your response concise, avoiding unnecessary information or details.",
    "mmlu_high_school_us_history_test": "You will be given a question from the MMLU dataset, covering subjects such as STEM, humanities, or social sciences. Carefully read each question and identify the relevant concepts and facts required to solve it. Answer the question directly and accurately using your subject knowledge. Briefly explain your reasoning and reference any essential evidence or logic. Keep your response concise, avoiding unnecessary information or details.",
    "mmlu_high_school_world_history_test": "You will be given a question from the MMLU dataset, covering subjects such as STEM, humanities, or social sciences. Carefully read each question and identify the relevant concepts and facts required to solve it. Answer the question directly and accurately using your subject knowledge. Briefly explain your reasoning and reference any essential evidence or logic. Keep your response concise, avoiding unnecessary information or details.",
    "mmlu_professional_law_test": "You will be given a question from the MMLU dataset, covering subjects such as STEM, humanities, or social sciences. Carefully read each question and identify the relevant concepts and facts required to solve it. Answer the question directly and accurately using your subject knowledge. Briefly explain your reasoning and reference any essential evidence or logic. Keep your response concise, avoiding unnecessary information or details.",
    "multiarith": "You will receive a math word problem from the MultiArith dataset, appropriate for elementary-level reasoning. Read the problem carefully, identify relevant quantities, and determine the necessary arithmetic operations. Break the problem into logical steps using addition, subtraction, multiplication, or division as needed. Show all intermediate steps in your explanation and justify each calculation clearly. Focus on providing a detailed, step-by-step solution with exact answers, avoiding unnecessary details.",
}

# ============================== #


def run_app(
    config,
    model,
    exp_name,
    exp_desc,
    dataset_name,
    sys_prompt,
    result_path,
):
    config["experiment"]["name"] = exp_name
    config["experiment"]["description"] = exp_desc

    config["components"]["task"]["question_answer"]["dataset_name"] = dataset_name
    config["components"]["task"]["question_answer"]["id_lst"] = []
    config["components"]["task"]["question_answer"]["prompt_msg_template"][0][
        "content"
    ] = sys_prompt

    config["output"]["results_dataframe"] = result_path
    config["config_anchors"] = None

    yaml_path = f"config/experiments/{model}/{dataset_name}_5sent_baseline.yaml"
    with open(
        yaml_path,
        "w",
    ) as out_f:
        yaml.dump(config, out_f)

    print(f"Running experiment for dataset: {dataset_name}")
    cmd = [
        "python",
        "app.py",
        "--config",
        f"{model}/{dataset_name}_5sent_baseline.yaml",
        "--quiet",
    ]
    subprocess.run(cmd, check=True)
    os.remove(yaml_path)


if __name__ == "__main__":

    for model in model_lst:
        print(model)
        with open(f"config/experiments/{model}/baseline_5sent.yaml", "r") as f:
            base_config = yaml.safe_load(f)

        for _idx in range(len(dataset_name)):

            for i in range(10, 11):
                results_path = f"results/old/baseline_5sent_{i}/{dataset_name[_idx]}_5sent_baseline_{model}.csv"

                sys_prompt = sys_prompt_dict[dataset_name[_idx]]

                run_app(
                    base_config,
                    model,
                    experiment_name[_idx],
                    experiment_description[_idx],
                    dataset_name[_idx],
                    sys_prompt,
                    results_path,
                )
