"""
Usage:
python app_batch_baseline_nosys.py
"""

import subprocess
import yaml
import os

# ============================== #
model_lst = [
    "gemini",
    "gpt4o",
    "sonnet",
]
dataset_name = [
    "gsm8k_1",
    "gsm8k_2",
    "gsm8k_3",
    "gsm8k_4",
    "aqua",
    "bbh_boolean_expressions",
    "bbh_causal_judgement",
    "bbh_movie_recommendation",
    "bbh_ruin_names",
    "bbh_temporal_sequences",
    "mmlu_college_medicine_test",
    "multiarith",
    "mmlu_high_school_us_history_test",
    "mmlu_high_school_world_history_test",
    "mmlu_professional_law_test",
]
experiment_name = [ds_n + "_nosysprompt_baseline" for ds_n in dataset_name]
experiment_description = [
    f"{ds_n} experiment with no system prompt" for ds_n in dataset_name
]


# ============================== #


def run_app(
    config,
    model,
    exp_name,
    exp_desc,
    dataset_name,
    sys_prompt,
    result_path,
):
    config["experiment"]["name"] = exp_name
    config["experiment"]["description"] = exp_desc
    config["components"]["task"]["question_answer"]["dataset_name"] = dataset_name
    config["components"]["task"]["question_answer"]["id_lst"] = []
    config["output"]["results_dataframe"] = result_path
    config["config_anchors"] = None

    yaml_path = f"config/experiments/{model}/{dataset_name}_nosysprompt_baseline.yaml"
    with open(
        yaml_path,
        "w",
    ) as out_f:
        yaml.dump(config, out_f)

    print(f"Running experiment for dataset: {dataset_name}")
    cmd = [
        "python",
        "app.py",
        "--config",
        f"{model}/{dataset_name}_nosysprompt_baseline.yaml",
        "--quiet",
    ]
    subprocess.run(cmd, check=True)
    os.remove(yaml_path)


if __name__ == "__main__":

    for model in model_lst:
        print(model)
        with open(f"config/experiments/{model}/baseline_nosys.yaml", "r") as f:
            base_config = yaml.safe_load(f)

        for _idx in range(len(dataset_name)):

            for i in range(4, 11):
                results_path = f"results/old/baseline_nosys_{i}/{dataset_name[_idx]}_nosysprompt_baseline_{model}.csv"

                run_app(
                    base_config,
                    model,
                    experiment_name[_idx],
                    experiment_description[_idx],
                    dataset_name[_idx],
                    None,
                    results_path,
                )
