"""
Usage:
python -m app_batch_psaollm_nosys
"""

import subprocess
import yaml
import os

# ============================== #
model_lst = [
    # "gemini",
    "gpt4o",
    # "sonnet",
]
dataset_name = [
    # "gsm8k_1",
    # "gsm8k_2",
    # "gsm8k_3",
    # "gsm8k_4",
    # "aqua",
    # "bbh_boolean_expressions",
    # "bbh_causal_judgement",
    # "bbh_movie_recommendation",
    # "bbh_ruin_names",
    # "bbh_temporal_sequences",
    # "mmlu_college_medicine_test",
    # "multiarith",
    # "mmlu_high_school_us_history_test",
    # "mmlu_high_school_world_history_test",
    "mmlu_professional_law_test_0",
    "mmlu_professional_law_test_1",
    "mmlu_professional_law_test_2",
    "mmlu_professional_law_test_3",
    "mmlu_professional_law_test_4",
]
experiment_name = [ds_n + "_nosys_psaollm" for ds_n in dataset_name]
experiment_description = [
    f"{ds_n} experiment with no system prompt psao llm" for ds_n in dataset_name
]


# ============================== #


def run_app(
    config,
    model,
    exp_name,
    exp_desc,
    dataset_name,
    sys_prompt,
    result_path,
):
    config["experiment"]["name"] = exp_name
    config["experiment"]["description"] = exp_desc
    config["components"]["task"]["question_answer_psao_llm"][
        "dataset_name"
    ] = dataset_name
    config["components"]["task"]["question_answer_psao_llm"]["id_lst"] = []
    config["output"]["results_dataframe"] = result_path
    config["config_anchors"] = None

    yaml_path = f"config/experiments/{model}/{dataset_name}_nosys_psaollm.yaml"
    with open(yaml_path, "w") as out_f:
        yaml.dump(config, out_f)

    print(f"Running experiment for dataset: {dataset_name}")
    cmd = [
        "python",
        "app.py",
        "--config",
        f"{model}/{dataset_name}_nosys_psaollm.yaml",
        "--quiet",
    ]
    subprocess.run(cmd, check=True)
    if os.path.exists(yaml_path):
        os.remove(yaml_path)


# ============================== #


if __name__ == "__main__":

    for _model in model_lst:

        print(_model)

        results_path = [
            f"output/{ds_n}_nosys_psaollm_{_model}.csv" for ds_n in dataset_name
        ]

        with open(f"config/experiments/{_model}/psaollm_nosys.yaml", "r") as f:
            config_base = yaml.safe_load(f)

        for _idx in range(len(dataset_name)):

            run_app(
                config_base,
                _model,
                exp_name=experiment_name[_idx],
                exp_desc=experiment_description[_idx],
                dataset_name=dataset_name[_idx],
                sys_prompt=None,
                result_path=results_path[_idx],
            )
