"""
Tasks Module

This module provides interfaces and implementations for different tasks.
"""

from src.tasks.base import TaskInterface
from src.tasks.tamper_detection import TamperDetectionTask
from src.tasks.question_answer import QATask
from src.tasks.question_answer_psao_optuna import QAPSAOOptunaTask
from src.tasks.question_answer_psao_llm import QAPSAOLLMTask


__all__ = [
    "TaskInterface",
    "TamperDetectionTask",
    "QATask",
    "QAPSAOOptunaTask",
    "QAPSAOLLMTask",
]
