"""
Core Module

This module provides the core infrastructure for the prompt optimisation framework.
"""

from .registry import (
    Registry,
    LLMRegistry,
    TaskRegistry,
    PromptoptimiserRegistry,
    EvaluatorRegistry,
    EmbeddingsRegistry,
    llm_registry,
    task_registry,
    prompt_optimiser_registry,
    evaluator_registry,
    embeddings_registry,
)
from .config import ConfigManager, config_manager
from .experiment import ExperimentRunner, ExperimentStep, load_experiment_results

__all__ = [
    # Registry
    "Registry",
    "LLMRegistry",
    "TaskRegistry",
    "PromptoptimiserRegistry",
    "EvaluatorRegistry",
    "EmbeddingsRegistry",
    "llm_registry",
    "task_registry",
    "prompt_optimiser_registry",
    "evaluator_registry",
    "embeddings_registry",
    # Config
    "ConfigManager",
    "config_manager",
    # Experiment
    "ExperimentRunner",
    "ExperimentStep",
    "load_experiment_results",
]
