"""
Question Answer Task Evaluator

This module provides an evaluator for the Question Answer task.
"""

import pandas as pd

from src.evaluation.base import BaseEvaluator
from src.utils.decorator_utils import with_logger


class QATaskEvaluator(BaseEvaluator):
    """
    Evaluator for the Question Answer task.

    This class evaluates the results of the Question Answer task.
    """

    @with_logger
    def __init__(self):
        """
        initialise the Question Answer evaluator.
        """
        super().__init__()

    @with_logger
    def get_eval_score(self, results: pd.DataFrame):
        """ """
        return results["score"].mean()
