from __future__ import annotations

"""
Tiny smoke-run for baseline log-likelihood timings. Runs a 1x1 grid on CPU.
Outputs JSON under outputs/fast_times/test.
"""

import sys
from pathlib import Path

# Allow running as a file or pasted into a notebook: add repo root to sys.path
if __package__ is None or __package__ == "":
    try:
        base = Path(__file__).resolve()
    except NameError:
        base = Path.cwd()
    ROOT = None
    for cand in [base] + list(base.parents):
        if (cand / "scripts").exists() or (cand / "pyproject.toml").exists() or (cand / ".git").exists():
            ROOT = cand
            break
    ROOT = ROOT or base
    if str(ROOT) not in sys.path:
        sys.path.insert(0, str(ROOT))

from scripts.fast_times.config import BenchConfig, BenchGrid, ModelDims, Runtime
from scripts.fast_times.run_baseline_ll import main as run_main


def tiny_config() -> BenchConfig:
    return BenchConfig(
        grid=BenchGrid(Nc_values=(32,), num_samples_values=(1,), Nt=4, num_runs=1),
        dims=ModelDims(dx=1, dy=1, d_model=32, n_heads=2, n_layers_enc=1, n_layers_dec=1, d_ff=64),
        runtime=Runtime(device="cuda", dtype="auto"),
        out_dir="outputs/fast_times/test",
        compile_mode="max-autotune",
    )


if __name__ == "__main__":
    cfg = tiny_config()
    run_main(cfg)
