#!/usr/bin/env bash

DATADIR=path_to_epic_dataset
WB_PROJECT=CRL
BATCH_SIZE=128

for ((SEED=1;SEED<=3;SEED++))
do
    sbatch -J $jid epic_${SEED} -e slurm_logs/epic_${SEED}  script/job.sh  --ood noun --data_root=$DATADIR --seed ${SEED} --log --batch_size ${BATCH_SIZE} --wb_project ${WB_PROJECT} --model PatchWiseDeltaEmbeddingModel --num_workers 12 --train_size 5000 --dataset epickitchens --data_root epic_image_pairs

done