#!/usr/bin/env bash

DATADIR=path_to_procthor_dataset
WB_PROJECT=CRL
BATCH_SIZE=128


for ((SEED=1;SEED<=3;SEED++))
do
    sbatch -J $jid single_comp_${SEED} -e slurm_logs/single_comp_${SEED}  script/job.sh  --ood comp --data_root=$DATADIR --seed ${SEED} --bbox --log --batch_size ${BATCH_SIZE} --wb_project ${WB_PROJECT} --model CausalDeltaEmbeddingModel --num_workers 12 --train_size 5000

    sbatch -J $jid single_noun_${SEED} -e slurm_logs/single_noun_${SEED}  script/job.sh  --ood noun --data_root=$DATADIR --seed ${SEED} --bbox --log --batch_size ${BATCH_SIZE} --wb_project ${WB_PROJECT} --model CausalDeltaEmbeddingModel --num_workers 12 --train_size 5000

done