#!/bin/bash
ts=$(date +%Y%m%d_%H%M%S)
output_dir="results/baselines_$ts"
log_dir="$output_dir/log"
result_dir="$output_dir/results"
time_dir="$output_dir/time"
mkdir -p "$log_dir" "$result_dir" "$time_dir"

echo "Result directory: $result_dir"
echo "Time directory: $time_dir"

for baseline_py in baselines/*.py; do
  if [ -f "$baseline_py" ]; then
    tag=$(basename "$baseline_py" .py)
    echo "Processing baseline: $baseline_py ..."

    for f in data/*.json; do
      if [ -f "$f" ]; then
        fname=$(basename "$f" .json)
        echo "  Processing data file: $f ..."
        CUDA_VISIBLE_DEVICES=0 nohup python "$baseline_py" \
          --data_path "$f" \
          --output_dir "$result_dir" \
          --file_name "${tag}_${fname}" \
          --model_id  "model_id" \
          --time_path "$time_dir" \
          > "$log_dir/${tag}_${fname}_$ts.log" 2>&1
      fi
    done
  fi
done

echo "全部处理完成，结果和日志都在: $output_dir"