This is the supplementary material for the paper:  
**"Symmetry-Aware Fully-Amortized Optimization with Scale Equivariant Graph Metanetworks"**.  

This codebase is an extension of the paper **"Scale Equivariant Graph Metanetworks"**.

---


To extract the CNN dataset move to the directory `data/` and execute:

```bash
tar -xvf cifar10.tar.xz
# download cifar10 splits
wget https://github.com/AllanYangZhou/nfn/raw/refs/heads/main/experiments/predict_gen_data_splits/cifar10_split.csv -O data/cifar10/cifar10_split.csv
```
Due to storage limitations, the MLP dataset has been omitted from the supplementary materials. It will be made available separately upon request.

## Configurations

The directory `configs/cifar10` contains six configurations which correspond to the optimal hyperparameter settings we found through a grid search.

---

## Training

To do training just run:

```bash
python -u scalegmn_optimizer_cnn_train.py --conf configs/cifar10/scalegmn_optimizer_cnn_tanh.yml
python -u scalegmn_optimizer_mlp_train.py --conf configs/cifar10/scalegmn_optimizer_mlp_tanh.yml

Evaluation

Once the model is trained, you can evaluate it on the test set using:

python -u scalegmn_optimizer_cnn_test.py --conf configs/cifar10/scalegmn_optimizer_cnn_tanh.yml
python -u scalegmn_optimizer_mlp_test.py --conf configs/cifar10/scalegmn_optimizer_mlp_tanh.yml

Breaking Scale Equivariance

To break the scale equivariance by omitting the canonicalization step simply run:

python -u scalegmn_optimizer_cnn_train.py --conf configs/cifar10/scalegmn_optimizer_cnn_tanh.yml --scalegmn_args.mlp_args.break_symmetry
python -u scalegmn_optimizer_mlp_train.py --conf configs/cifar10/scalegmn_optimizer_mlp_tanh.yml --scalegmn_args.mlp_args.break_symmetry