# FedAvg
## Prerequisite
- Python 3.9
```bash
conda create -n Federico python=3.9
conda activate Federico
```
- PyTorch 1.9.0
```bash
conda install pytorch=1.9.0 torchvision=0.10.0 numpy=1.21.2 -c pytorch
```
- mpi4py 3.1.2
```bash
conda install -c conda-forge mpi4py=3.1.2
```
- opacus 0.14.0
```bash
pip install 'opacus==0.14.0'
```
- matplotlib 3.4.3
```bash
conda install -c conda-forge matplotlib=3.4.3
```
- sklearn
```bash
conda install scikit-learn==1.0.2
```

- cvxpy
```bash
conda install -c conda-forge cvxpy
```

- pandas
```bash
conda install pandas==1.3.5
```

## Run experiment
To download data
```bash
mkdir datasets
cd datasets
wget https://storage.googleapis.com/tensorflow/tf-keras-datasets/mnist.npz

mkdir cifar10
cd cifar10
wget https://www.cs.toronto.edu/~kriz/cifar-10-python.tar.gz
tar -xvzf cifar-10-python.tar.gz

mkdir cifar100
cd cifar100
wget https://www.cs.toronto.edu/~kriz/cifar-100-python.tar.gz
tar -xzf cifar-100-python.tar.gz
```
Then run the script
```bash
. /expereiment_scripts/run_cifar10.sh
. /expereiment_scripts/run_cifar100.sh
```

## Reference
[FEDEM repo](https://github.com/echoyi/FedEM)
