#!/usr/bin/env bash
# export OMPI_MCA_btl_vader_single_copy_mechanism=none

use_private_SGD=0
delta=0.00001
noise_multiplier=1.0
l2_norm_clip=1.0
n_epochs=1
optimizer='adam'
verbose=1

dataset='cifar10' 
private_model_type='CNN2'  
n_rounds=150
n_clients=8
batch_size=50

algorithms=( 'Federico' 'DFedEM' 'FedFomo' 'FedAvg' 'FedAvg+' 'Regular' 'CFL') 
seeds=(0 1 2)
n_runs=${#seeds[@]}

frac=0.1
cw_ratio=0.2
n_clusterss=(2 3 4)
n_components=4
lr=0.01
n_neighbors=3
greedy_eps=0.6

cw_momentum=0.6
class_seeds=(2020 2021 2023 11 22)
seeds=(0 1 2)

for n_clusters in ${n_clusterss[@]} 
do
    for class_seed in ${class_seeds[@]}
    do  
        for seed in ${seeds[@]}
        do
            for algorithm in "${algorithms[@]}"
            do
                mpiexec -n ${n_clients} python run_exp.py \
                        --dataset=${dataset} \
                        --algorithm=${algorithm} \
                        --n_components=${n_components} \
                        --n_neighbors=${n_neighbors}\
                        --seed=${seed} \
                        --class_seed=${class_seed} \
                        --frac=${frac} \
                        --n_clusters=${n_clusters} \
                        --n_clients=${n_clients} \
                        --private_model_type=${private_model_type} \
                        --use_private_SGD=${use_private_SGD} \
                        --delta=${delta} \
                        --noise_multiplier=${noise_multiplier} \
                        --l2_norm_clip=${l2_norm_clip} \
                        --optimizer=${optimizer} \
                        --lr=${lr} \
                        --n_epochs=${n_epochs} \
                        --n_rounds=${n_rounds} \
                        --batch_size=${batch_size} \
                        --verbose=${verbose} \
                        --cw_ratio=${cw_ratio}\
                        --cw_momentum=${cw_momentum} \
                        --greedy_eps=${greedy_eps}\
                        --n_local_epochs=1\
                        # --rerun\            
            done
        done
    done
done

for n_clusters in ${n_clusterss[@]}
do
    python plot_res_acc_cifar10.py \
        --algorithms "${algorithms[@]}"\
        --n_runs=${n_runs} \
        --dataset=${dataset} \
        --n_clients=${n_clients} \
        --private_model_type=${private_model_type} \
        --use_private_SGD=${use_private_SGD} \
        --delta=${delta} \
        --noise_multiplier=${noise_multiplier} \
        --l2_norm_clip=${l2_norm_clip} \
        --n_rounds=${n_rounds} \
        --optimizer=${optimizer} \
        --lr=${lr} \
        --frac=${frac} \
        --n_clusters=${n_clusters} \
        --class_seeds ${class_seeds[@]} \
        --seeds ${seeds[@]}\
        --batch_size=${batch_size}\
        --n_neighbors=${n_neighbors}\
        --cw_ratio=${cw_ratio}\
        --cw_momentum=${cw_momentum}\
        --greedy_eps=${greedy_eps}
done