#!/usr/bin/env bash
# export OMPI_MCA_btl_vader_single_copy_mechanism=none
use_private_SGD=0
delta=0.00001
noise_multiplier=1.0
l2_norm_clip=1.0\

n_epochs=1
optimizer='adam'
verbose=1

# MNIST and Fashion-MNIST
dataset='cifar100' #'mnist'
private_model_type='ResNet18'
n_rounds=150
n_clients=8
batch_size=50 

algorithms=('Federico' 'DFedEM' 'FedFomo' 'FedAvg' 'FedAvg+' 'Regular' 'CFL')
n_runs=1

frac=0.15
n_clusterss=(2 3)
n_components=4
lr=0.01
n_neighbors=3
greedy_eps=0.3
cw_momentum=0.6
class_seeds=(12345 2021 1024)
cw_ratio=0.2

for n_clusters in ${n_clusterss[@]}
do
    for class_seed in ${class_seeds[@]} 
    do
        for algorithm in "${algorithms[@]}"
        do
            mpiexec -n ${n_clients} python run_exp.py \
                    --dataset=${dataset} \
                    --algorithm=${algorithm} \
                    --n_components=${n_components} \
                    --n_neighbors=${n_neighbors}\
                    --seed=${class_seed} \
                    --class_seed=${class_seed} \
                    --frac=${frac} \
                    --n_clusters=${n_clusters} \
                    --n_clients=${n_clients} \
                    --private_model_type=${private_model_type} \
                    --use_private_SGD=${use_private_SGD} \
                    --delta=${delta} \
                    --noise_multiplier=${noise_multiplier} \
                    --l2_norm_clip=${l2_norm_clip} \
                    --optimizer=${optimizer} \
                    --lr=${lr} \
                    --n_epochs=${n_epochs} \
                    --n_rounds=${n_rounds} \
                    --batch_size=${batch_size} \
                    --verbose=${verbose} \
                    --cw_ratio=${cw_ratio}\
                    --cw_momentum=${cw_momentum} \
                    --greedy_eps=${greedy_eps} \
                    --n_local_epochs=5 \
                    # --rerun\
                    
        done
    done
    python plot_res_acc_cifar100.py \
        --algorithms "${algorithms[@]}"\
        --class_seeds ${class_seeds[@]}\
        --n_runs=${n_runs} \
        --dataset=${dataset} \
        --n_clients=${n_clients} \
        --private_model_type=${private_model_type} \
        --use_private_SGD=${use_private_SGD} \
        --delta=${delta} \
        --noise_multiplier=${noise_multiplier} \
        --l2_norm_clip=${l2_norm_clip} \
        --n_rounds=${n_rounds} \
        --optimizer=${optimizer} \
        --lr=${lr} \
        --frac=${frac} \
        --n_clusters=${n_clusters} \
        --batch_size=${batch_size}\
        --n_neighbors=${n_neighbors}\
        --cw_ratio=${cw_ratio}\
        --cw_momentum=${cw_momentum}\
        --greedy_eps=${greedy_eps}
done

 

class_seeds=(11 22 1024)
n_clusters=4
for class_seed in ${class_seeds[@]}
do
    for algorithm in "${algorithms[@]}"
    do
        mpiexec -n ${n_clients} python run_exp.py \
                --dataset=${dataset} \
                --algorithm=${algorithm} \
                --n_components=${n_components} \
                --n_neighbors=${n_neighbors}\
                --seed=${class_seed} \
                --class_seed=${class_seed} \
                --frac=${frac} \
                --n_clusters=${n_clusters} \
                --major_percent=${major_percent} \
                --n_clients=${n_clients} \
                --private_model_type=${private_model_type} \
                --use_private_SGD=${use_private_SGD} \
                --delta=${delta} \
                --noise_multiplier=${noise_multiplier} \
                --l2_norm_clip=${l2_norm_clip} \
                --optimizer=${optimizer} \
                --lr=${lr} \
                --n_epochs=${n_epochs} \
                --n_rounds=${n_rounds} \
                --batch_size=${batch_size} \
                --verbose=${verbose} \
                --cw_ratio=${cw_ratio}\
                --cw_momentum=${cw_momentum} \
                --greedy_eps=${greedy_eps} \
                --n_local_epochs=5
                # --rerun\
    done
done

python plot_res_acc_cifar100.py \
        --algorithms "${algorithms[@]}"\
        --class_seeds ${class_seeds[@]}\
        --n_runs=${n_runs} \
        --dataset=${dataset} \
        --n_clients=${n_clients} \
        --private_model_type=${private_model_type} \
        --use_private_SGD=${use_private_SGD} \
        --delta=${delta} \
        --noise_multiplier=${noise_multiplier} \
        --l2_norm_clip=${l2_norm_clip} \
        --n_rounds=${n_rounds} \
        --optimizer=${optimizer} \
        --lr=${lr} \
        --frac=${frac} \
        --n_clusters=${n_clusters} \
        --batch_size=${batch_size}\
        --n_neighbors=${n_neighbors}\
        --cw_ratio=${cw_ratio}\
        --cw_momentum=${cw_momentum}\
        --greedy_eps=${greedy_eps}


class_seed=22
seed=0
algorithms=('DFedEM' 'Federico')

for algorithm in ${algorithms[@]}
do
    python plot_res_cw.py \
        --algorithm=${algorithm}\
        --dataset=${dataset} \
        --n_clients=${n_clients} \
        --private_model_type=${private_model_type} \
        --use_private_SGD=${use_private_SGD} \
        --delta=${delta} \
        --noise_multiplier=${noise_multiplier} \
        --l2_norm_clip=${l2_norm_clip} \
        --n_rounds=${n_rounds} \
        --optimizer=${optimizer} \
        --lr=${lr} \
        --frac=${frac} \
        --n_cluster=${n_clusters} \
        --class_seed=${class_seed} \
        --seed=${seed}\
        --batch_size=${batch_size}\
        --n_neighbors=${n_neighbors}\
        --cw_ratio=${cw_ratio}\
        --cw_momentum=${cw_momentum}\
        --greedy_eps=${greedy_eps}
done