export MASTER_PORT=1001

features=vitbase_r2rfte2e
ft_dim=768
feedback=sample
ngpus=1
seed=0

outdir=../datasets/R2R/trained_models/vitbase-finetune-e2e-back/test

flag="--root_dir ../datasets
      --dataset r2r_back
      --output_dir ${outdir}
      --img_db_file ../datasets/R2R/features/panoimages.lmdb

      --seed ${seed}

      --ngpus ${ngpus}

      --fix_lang_embedding
      --fix_hist_embedding

      --hist_enc_pano
      --hist_pano_num_layers 2
      
      --features ${features}
      --feedback ${feedback}

      --maxAction 30
      --batch_size 1
      --image_feat_size ${ft_dim}

      --lr 1e-5
      --iters 300000
      --log_every 1000
      --optim adamW

      --mlWeight 0.2
      --maxInput 60
      --angle_feat_size 4
      --featdropout 0.4
      --dropout 0.5"

CUDA_VISIBLE_DEVICES='0' python r2r/main.py $flag \
      --resume_file ../datasets/R2R/exprs_r2rback/ckpts/best_val_unseen \
      --test --submit