export MASTER_PORT=1902

features=vitbase_r2rfte2e
ft_dim=768
feedback=argmax
ngpus=1

outdir=../datasets/R2R/trained_models/vitbase-finetune-e2e-last/eff_last_ex_8
flag="--root_dir ../datasets
      --output_dir ${outdir}
      --img_db_file ../datasets/R2R/features/panoimages.lmdb

      --dataset r2r_last
      --ngpus ${ngpus}
      
      --hist_enc_pano
      --hist_pano_num_layers 2

      --fix_lang_embedding
      --fix_hist_embedding

      --features ${features}
      --feedback ${feedback}

      --maxAction 15
      --batch_size 1
      --image_feat_size ${ft_dim}

      --lr 1e-5
      --iters 300000
      --log_every 1000
      --optim adamW

      --mlWeight 0.2
      --maxInput 60
      --angle_feat_size 4
      --featdropout 0.4
      --dropout 0.5"

CUDA_VISIBLE_DEVICES='0' python r2r/main.py $flag \
      --resume_file ../datasets/R2R/exprs_r2rlast/ckpts/best_val_unseen \
      --test --submit
