export MASTER_PORT=1727

features=vitbase_r2rfte2e
ft_dim=768
feedback=argmax
ngpus=1

outdir=../datasets/R2R/trained_models/vitbase-finetune-e2e-r4r/efficient-r4r

flag="--root_dir ../datasets
      --dataset r4r
      --img_db_file ../datasets/R2R/features/panoimages.lmdb
      --output_dir ${outdir}
      --seed 0
      --ngpus ${ngpus}

      --no_lang_ca
      --ob_type pano
      --hist_enc_pano
      --hist_pano_num_layers 2

      --features ${features}
      --feedback ${feedback}

      --maxInput 100
      --maxAction 30
      --image_feat_size ${ft_dim}
      --angle_feat_size 4

      --lr 1e-5
      --iters 300000
      --log_every 1000
      --optim adamW

      --mlWeight 0.2
      
      --batch_size 1
      --featdropout 0.4
      --dropout 0.5"

CUDA_VISIBLE_DEVICES='0' python r2r/main.py $flag \
      --resume_file ../datasets/R2R/exprs_r4r/ckpts/best_val_unseen_sampled \
      --test --submit
