
Evolving Standardization for Continual Domain Generalization over Temporal Drift

# Datasets

* yearbook is available at [here](https://drive.google.com/u/0/uc?id=1mPpxoX2y2oijOvW1ymiHEYd7oMu2vVRb&export=download)
* MNIST is available at [here](http://yann.lecun.com/exdb/mnist/)
* fmow is available at [here](https://drive.google.com/u/0/uc?id=1s_xtf2M5EC7vIFhNv_OulxZkNvrVwIm3&export=download)
* huffpost is available at [here](https://drive.google.com/u/0/uc?id=1jKqbfPx69EPK_fjgU9RLuExToUg7rwIY&export=download)
* arxiv is available at [here](https://drive.google.com/u/0/uc?id=1H5xzHHgXl8GOMonkb6ojye-Y2yIp436V&export=download)


# Environments

To try out this project, it is recommended to set up a virtual environment first.

```
conda create --name env_name python=3.8.16
conda activate env_name
pip install -r requirements.txt 
python3 -m pip install torch==1.9.1+cu111 torchvision==0.10.1+cu111 torchaudio==0.9.1 -f https://download.pytorch.org/whl/torch_stable.html
python3 -m pip install wildtime==1.1.3
python3 -m pip install yacs
python3 -m pip install transformers==4.21.1
```


# Code Running

An example of running the code on the Yearbook dataset:

```
python3 main_xmx.py --dataset 'yearbook' --method 'evos' device 1 our_group_size 4 init_timestamp 0 split_time 15 epochs 50 lr 1e-3 scale 3 tradeoff_adv 1.0 num_head 16 dim_head 8 truncate 1.0
```






