import json
import uuid
import os

def load_templates(path):
    with open(path, 'r') as file:
        return json.load(file)

def read_questions(path):
    questions = {}
    with open(path, 'r') as file:
        content = file.read().split('TEMPLATE_ID ')
        for entry in content[1:]:
            parts = entry.strip().split('---')
            template_id = parts[0].strip()
            print(template_id)
            qa_text = parts[1].strip()

            questions_list = []
            qa_pairs = qa_text.split('Q\n') # IMPORTANT
            qa_pairs = [qa_pair.strip() for qa_pair in qa_pairs if qa_pair.strip() != ""]
            for qa in qa_pairs:
                q, a = qa.split('A\n') # IMPORTANT
                question = q.strip()
                answer = a.strip()
                questions_list.append({'question': question, 'answer': answer})
            questions[template_id] = questions_list
            if len(questions_list) != 5:
                print("Only", len(questions_list), "questions extracted.")
                print("Could not process template", template_id, ". The qa-s extracted were: ", questions_list)
    return questions

def generate_data(templates, questions, output_path):
    data = []
    id_counter = 1  # Initialize counter for unique integer IDs
    for template in templates:
        template_id = str(template['template_id'])  # Convert to string to match keys
        template_qs = questions.get(template_id, [])
        for i, qa in enumerate(template_qs):
            new_entry = template.copy()
            new_entry['id'] = id_counter
            new_entry['problem'] = template['problem'] + " " + qa['question']  # Update problem field
            new_entry['answer'] = qa['answer']  # Update answer field
            data.append(new_entry)
            id_counter += 1
    with open(output_path, 'w') as file:
        json.dump(data, file, indent=4)

# Paths to the files and directories
templates_complete_path = 'templates_complete.json'
qs_path = 'qs.txt'
output_path = '../new/data.json'

# Ensure the output directory exists
os.makedirs(os.path.dirname(output_path), exist_ok=True)

# Main processing steps
templates = load_templates(templates_complete_path)
questions = read_questions(qs_path)
generate_data(templates, questions, output_path)

print("Data has been processed and saved to", output_path)
