import math

##################
### HELPERS
##################
def par(rs): # resistors in parallel
    return 1/sum([1/r for r in rs])

def ser(rs): # resistors in series
    return sum(rs)

def curr_divider(Itot, Roth, Rn):
    return Itot * Roth/(Rn+Roth)

def volt_divider(Vtot, Roth, Rn):
    return Vtot * Rn/(Rn+Roth)


##################
### QUESTIONS
##################

def qid10000(v ,r):
    return v/r

##################
### TESTING
##################

# print(qid10000(1, 1))
