import json

def combine_json_data(file1, file2):
    # Load file1 and file2
    with open(file1, 'r') as f1, open(file2, 'r') as f2:
        data1 = json.load(f1)
        data2 = json.load(f2)

    # Create a dictionary to map problem_id to responses from both files
    combined_data = {}

    # Combine the data from file1
    for entry in data1:
        problem_id = entry['problem_id']
        combined_data[problem_id] = entry['response']

    # Combine the data from file2
    for entry in data2:
        problem_id = entry['problem_id']
        combined_data[problem_id] = entry['response']

    # Convert combined data back into a list of dictionaries
    combined_list = [{'problem_id': k, 'response': v} for k, v in combined_data.items()]

    # Write the combined data back to file1
    with open(file1, 'w') as f1:
        json.dump(combined_list, f1, indent=4)
