# SYSTEM INSTRUCTIONS
SYSTEM_ROLE_0 = "You are an electrical engineering expert. Solve a given problem step by step. \n\
    At the end of your solution, write \"Final Numerical Answer: N\" where N is your final numerical answer. \
    If the problem did not have enough information needed to solve it, put \"Unknown\" in place of N. \
    If the problem setup is invalid, and thus the problem does not have a solution, put \"None\" in place of N.\
    The final numerical answer, if different from Unknown and None, should be with precision up to 6 decimal places.\
    The numerical answer should be a decimal number with 6 digits after the decimal point. Don't write fractions or numbers \
    in any other format. Don't write any further explanations after the Final Numerical Answer. \n\
    Here is an example of the answer format:\n\
    Question:\n\
    What is x = 2 + 2 * 2?\n\
    Step by step solution:\n\
    Following the PEMDAS rule, we first multiply 2 * 2 = 4. Then, we add 2 + 4 to get x = 6.\n\
    Final Numerical Answer: 6.000000\n\n"

SYSTEM_ROLE_1_NN = "Here is an example problem and solution:\n\
Example Problem:\n\
Consider the circuit in the example diagram. Determine $v$ in Volts.\n\
Solution:\n\n\
We are asked to find the voltage $v$ across the current source in the figure. \
We can see in the figure that the circuit consists of a current source $I_1$ and a resistor network. \
If we can find the equivalent resistance of the resistor network, we can determine the voltage $v$ using Ohm's law.\n\
From the figure, we can see that $R_1$ and $R_2$ are connected in parallel. Their combination is connected in series \
to a parallel combination of $R_3$ and $R_4$. And this parallel combination is connected in series with $R_5$.\n\
Therefore, we find that $R_{eq} = R_{12} + R_{34} + R_5 = R_{12} + R_{34} + 100 \\Omega$. Since $R_1$ and $R_2$ are \
parallel to each other, we find that $R_{12} = \\frac{1}{\\frac{1}{R_1} + \\frac{1}{R_2}} = \\frac{1}{\\frac{1}{500} + \
\\frac{1}{500}} = \\frac{1}{\\frac{2}{500}} = \\frac{500}{2} = 250 \\Omega. Similarly, $R_{34} = \\frac{1}{\\frac{1}{R_3} \
+ \\frac{1}{R_4}} = \\frac{1}{\\frac{1}{300} + \\frac{1}{100}} = \\frac{1}{\\frac{100 + 300}{100 (300)}} = \
\\frac{30000}{400} = 75 \\Omega.\n\
Thus, $R_{eq} = R_{12} + R_{34} + R_5 = 250 \\Omega + 75 \\Omega + 100 \\Omega = 425 \\Omega$. \
Using Ohm's Law, we find that $v = I_1 R_{eq} = 2 A (425 \\Omega) = 850 V.\n\
Final Numerical Answer: 850.000000\n\n"

SYSTEM_ROLE_1_WN = "Here is an example problem and solution:\n\
Example Problem:\n\
Consider the circuit in the example diagram. Determine $v$ in Volts.\n\
Netlist:\n\
```\n\
I1 0  N1 2\n\
R1 N1 N2 500\n\
R2 N1 N2 500\n\
R3 N2 N3 300\n\
R4 N2 N3 100\n\
R5 N3 0  100\n\
```\n\n\
Solution:\n\n\
We are asked to find the voltage $v$ across the current source in the figure. We can see in the figure that \
the circuit consists of a current source $I_1$ and a resistor network. If we can find the equivalent resistance \
of the resistor network, we can determine the voltage $v$ using Ohm's law.\n\
From the figure, we can see that $R_1$ and $R_2$ are connected in parallel. Their combination is connected in series \
to a parallel combination of $R_3$ and $R_4$. And this parallel combination is connected in series with $R_5$. We \
confirm this in the netlist. R1 and R2 share two same nodes N1 and N2, so they are connected in parallel. R3 and R4 \
share two same nodes N2 and N3, so they are connected in parallel. R1, R2, R3, and R4 share node N2, so the parallel \
combinations R12 and R34 are connected in series. Finally, R3, R4, and R5 share a node N3, so the parallel combination \
R34 and R5 are connected in series.\n\
Therefore, we find that $R_{eq} = R_{12} + R_{34} + R_5 = R_{12} + R_{34} + 100 \\Omega$. Since $R_1$ and $R_2$ are \
parallel to each other, we find that $R_{12} = \\frac{1}{\\frac{1}{R_1} + \\frac{1}{R_2}} = \\frac{1}{\\frac{1}{500} + \
\\frac{1}{500}} = \\frac{1}{\\frac{2}{500}} = \\frac{500}{2} = 250 \\Omega. Similarly, $R_{34} = \\frac{1}{\\frac{1}{R_3}\
 + \\frac{1}{R_4}} = \\frac{1}{\\frac{1}{300} + \\frac{1}{100}} = \\frac{1}{\\frac{100 + 300}{100 (300)}} = \
\frac{30000}{400} = 75 \\Omega.\n\
Thus, $R_{eq} = R_{12} + R_{34} + R_5 = 250 \\Omega + 75 \\Omega + 100 \\Omega = 425 \\Omega$. \
Using Ohm's Law, we find that $v = I_1 R_{eq} = 2 A (425 \\Omega) = 850 V.\n\n\
Final Numerical Answer: 850.000000\n\n"

SYSTEM_ROLE_1_DIAGRAM = "example-diagram"

# NETLIST INSTRUCTIONS
NETLIST_INSTRUCTION_START = "To better understand the given circuit diagram also take a look at the following \
    netlist-like description of the circuit. \
    Some elements and nodes are have no label/name on the diagram, but they are given names in \
    the netlists. Note that <value> of an element in the netlist is given in standard units and it is optional \
    (it can be included but does not have to be in the netlist descritption of an element).\n\
    In the netlist, the elements are listed as:\n"
# Choose by first letter -- don't forget to uppercase
NETLIST_INSTRUCTION_DICT = {
    "R"     : "Resistor: R<string> node_1 node_2 <value>\n",
    "C"     : "Capacitor: C<string> node_1 node_2 <value>\n",
    "L"     : "Inductor: L<string> node_1 node_2 <value>\n",
    "V"     : "Voltage source: V<string> node_+ node_- <value>\n",
    "I"     : "Current source: I<string> node_from node_to <value>\n",
    "S"     : "Simple switch: S<string> node_1 node_2\n",
    "D"     : "Diode: D<string> n_anode n_cathode\n",
    "H"     : "Current-controlled voltage source: H<string> node_+ node_- <name of the current controlling the source> <transresistance>\n",
    "G"     : "Voltage-controlled current source: G<string> node_1 node_2 <name of the voltage controlling the source> <transconductance>\n",
    "OPA"   : "Simple Op-Amp: OPA<string> node_output node_input_+ node_input_- <gain (optional)>\n",
    "M"     : "MOS Transistor: M<string> n_drain n_gate n_source n_body NMOS/PMOS\n",
    "Q"     : "BJT: Q<string> n_collector n_base n_emitter PNP/NPN\n",
    "Y"     : "Anonymous element: Y<string> node_1 node_2\n",
    "K"     : "Mutual Inductors: K<string> <inductor1> <inductor2> <number of turns in inductor1>:<number of turns in inductor2>\n"
    }
# Comment inline ;
NETLIST_INSTRUCTION_INLINE_COMMENT = "The netlist contains inline comments labeled with \";\", \
    mostly indicating voltages or currents labeled on the diagram. If there is a minus sign, that means \
    the voltage or the current is measured in the opposite direction from the nodes listed for that \
    element. For example, if there is a line \"E N1 N2 ; v\", the voltage v is measured node N1 to N2. \
    That is, N1 is the positive node of the measured voltage v, and N2 is the negative node. \
    On the other hand, if there is a line  \"E N1 N2 ; -v\", the voltage v is measured node N2 to N1. \
    If the comment is about a current, it is the current measured through the listed element E flowing from \
    N1 to N2 if there is a line \"E N1 N2 ; i\", and flowing from N2 to N1 if there is a line \"E N1 N2 ; -i\"\
    Furthermore, note that the positive current direction is into drain node for an NMOS element and \
    out of drain node for a PMOS element.\n"
# Comment *
NETLIST_INSTRUCTION_COMMENT = "The netlist also includes comments marked with \"*\".\n"
