# Source Repo of Memory-Efficient Algorithm Distillation for In-context Reinforcement Learning

This is the repo of source code of our paper *Memory-Efficient Algorithm Distillation for In-context Reinforcement Learning* which is currently under double-blind review.


## Repo structure

As noted in the paper, this repo contains codes of environments implementation, dataset collection and AD-like algorithms training  
They are in separate folders inside `src`:  
- algos: contains all the algorithms implemented.
- conf: includes config file (in `.yaml`) for both data collecting and training.
- envs: contain environment implementation.
- entries: `src/collect.py` for collecting dataset in envs, `src/train.py` for performing AD-like algos training using collected datasets.


## Installation
we strongly recommend install via docker for the best reproducibility and easiness:
```bash
cd docker
docker build -t EAD:v1 .
```


## Data collection
The envs and data collecting algos in this repo is implemented in JAX for best parallelism.  
And the command to collect dataset in parallel is:  
```bash
NO_TQDM=10000 PYTHONUNBUFFERED=1 ENV=dark_room ENV_SIZE=normal ENV_KIND=normal SEED=11111 bash -c 'python3 src/collect.py +env=${ENV} +algo=q_learning env.kind=${ENV_KIND} env.size_kind=${ENV_SIZE} seed=${SEED} name=collect'
```


## Training over collected dataset
After collecting dataset via previous methods, you could perform the following command to train AD-like algos in ICL style:  
```bash
NO_TQDM=10000 PYTHONUNBUFFERED=1 ENV=dark_room ENV_SIZE=normal ENV_KIND=normal ALGO=ad SEED=11111 dataset_path=... bash -c 'python3 src/train.py +env=${ENV} +algo=${ALGO} env.kind=${ENV_KIND} env.size_kind=${ENV_SIZE} seed=${SEED} name=train_ad load_path=${dataset_path}/models/'
```

```bash
NO_TQDM=10000 PYTHONUNBUFFERED=1 ENV=dark_room ENV_SIZE=normal ENV_KIND=normal ALGO=ed SEED=33333 dataset_path=... bash -c 'python3 src/train.py +env=${ENV} +algo=${ALGO} env.kind=${ENV_KIND} env.size_kind=${ENV_SIZE} seed=${SEED} name=train_ed load_path=${dataset_path}/models/'
```


## Note
Currently under review, DO NOT DISTRIBUTE