import os

os.environ["XLA_PYTHON_CLIENT_MEM_FRACTION"] = ".85"
from utils.seed import seed_all
from utils.reporter import init_reporter
from omegaconf import DictConfig, OmegaConf
from hydra.core.hydra_config import HydraConfig
import hydra
from envs import get_env_refill_cfg
from algos import get_algo_refill_cfg
from collect_handle import collect_handle
import logging
import chex


@hydra.main(version_base="1.3", config_path="conf", config_name="collect")
def main(cfg: DictConfig):
    seed_all(cfg.seed)
    if not cfg.debug:
        chex.disable_asserts()

    cfg, dcfg = get_env_refill_cfg(cfg.env.name)(cfg)

    cfg, dcfg2 = get_algo_refill_cfg(cfg.algo.name)(cfg)

    dcfg = {**dcfg, **dcfg2}

    output_dir = HydraConfig.get().runtime.output_dir

    print(f"Output directory: {output_dir}")
    print("cfg ---------")
    print(OmegaConf.to_yaml(cfg))
    print("cfg end ------")
    print(f"dcfg: --------")
    print(dcfg)
    print("dcfg end ---------")

    init_reporter(output_dir)

    collect_handle(cfg, dcfg)


if __name__ == "__main__":
    main()
