#!/bin/bash

path=/local/home/author/run-data/test
dataset_path=/local/home/author/run-data

dataset=MNIST1D
# dataset=MNIST
# dataset=CIFAR10
# dataset=miniCIFAR10

model_name=FF_ReLU_256
# model_name=LeakyOutput_FF_ReLU_256
# model_name=CNN_20

loss=CrossEntropy
# loss=MSE

optim=SGD
# optim=Adam
lr=0.05
# lr_scheduler=Warmup20000Step25
lr_scheduler=Cont100
# lr_scheduler=Const

batch_size=512

alpha_shuffle=0.0
seed=42

target_norm_grad=0.01 

min_num_epochs=100
max_num_epochs=5000

compute_L_every=100
compute_L_for_first=100

# device=GPU
device=CPU

runtimestamp=`date +%s`

# start training
CUDA_VISIBLE_DEVICES="0" pipenv run python code/train.py \
    --dataset $dataset --model_name $model_name --loss $loss \
    --optim $optim --lr $lr --lr_scheduler $lr_scheduler \
    --alpha_shuffle $alpha_shuffle --seed $seed --batch_size $batch_size \
    --target_norm_grad $target_norm_grad --runtimestamp $runtimestamp \
    --path $path --dataset_path $dataset_path --device $device \
    --max_num_epochs $max_num_epochs --min_num_epochs $min_num_epochs \
    --compute_L_every $compute_L_every --compute_L_for_first $compute_L_for_first
