#!/bin/bash
dataset_path=/local/home/stuff/imagenet
path=/local/home/author/run-data/resnet50-imagenet
checkpoint_path=/local/home/author/run-data/resnet50_imagenet_ep-90_lr-0.1_bsz-256_mom-0.9_wdecay-0.0001_seed-0_2023-02-21_10-45-30_983469

width=50
weights=PRETRAINED
batch_size=10
epoch=10

runtimestamp=`date +%s`

# start the computation
CUDA_VISIBLE_DEVICES="" pipenv run python code/resnet_lower_lip_imagenet.py \
    --width $width --weights $weights \
    --nsplits 3 --split_index 3 --batch_size $batch_size --train_ds_len 100 \
    --save_every_k_images 10 --runtimestamp $runtimestamp \
    --dataset_path $dataset_path --path $path \
    --checkpoint_path $checkpoint_path --checkpoint_epoch $epoch
