# Anchor-MoE: A Mean-Anchored Mixture of Experts For Probabilistic Regression
## Repository structure
```bash
.
├── README.md
├── LICENSE
├── Moe_Vs_Others.ipynb            # Compare Anchor-MoE with NGBoost (NLL/RMSE)
├── ablation_anchor.ipynb          # Ablation: remove Anchor
├── ablation_router.ipynb          # Ablation: remove Router
├── ablation_calibration.ipynb     # Ablation: remove Calibration
├── generate_figures.ipynb         # Scripts to reproduce paper figures
└── data/                          # (Local) datasets or cached splits
```

## Reproducing results

Open the notebooks in Jupyter and run top-to-bottom:
	•	Moe_Vs_Others.ipynb for main comparisons (UCI benchmarks).
	•	ablation_*.ipynb for ablations (Anchor / Router / Calibration).
	•	generate_figures.ipynb to regenerate figures used in the paper.


