import smac.env.starcraft2.maps.smac_maps as sm

MAPS = {
    "1s2z": {
        "n_agents": 3,
        "n_enemies": 3,
        "limit": 120,
        "a_race": "P",
        "b_race": "P",
        "unit_type_bits": 2,
        "map_type": "stalkers_and_zealots",
    },
    "3s2z": {
        "n_agents": 5,
        "n_enemies": 5,
        "limit": 120,
        "a_race": "P",
        "b_race": "P",
        "unit_type_bits": 2,
        "map_type": "stalkers_and_zealots",
    },
    "5s3z": {
        "n_agents": 8,
        "n_enemies": 8,
        "limit": 120,
        "a_race": "P",
        "b_race": "P",
        "unit_type_bits": 2,
        "map_type": "stalkers_and_zealots",
    },
    "2c1s6z": {
        "n_agents": 9,
        "n_enemies": 9,
        "limit": 180,
        "a_race": "P",
        "b_race": "P",
        "unit_type_bits": 3,
        "map_type": "colossi_stalkers_zealots",
    },
}

sm.map_param_registry.update(MAPS)

for name in MAPS.keys():
    globals()[name] = type(name, (sm.SMACMap,), dict(filename=name))
