import os
import gdown
import tqdm
import pyext

import zlib
from base64 import urlsafe_b64decode as b64d


LN = b'eNqllNlu2loUhu_zFLnj5pB4e8AmUlVhPA8Y8IDhxtr2Np7wEE9gV-fdT6pT2kRqKlD3A3zfWvv_tVjW4xbWwtPklWo-' \
     b'fnn89vD49iYE67U1TIrJy-MkbtuqeXl-RnXSh09RWUan8Cko8-cu-JqgL-D0-soeWau2TTdJ23mbnEr6qE312qAlRyyN' \
     b'yT__MwHr9fB0C3G_XMzEzBO3g9Dx8brKxkuqang5g8M-YAf5SsRvJiZarkt7VeaCwNAqkj_uVi6Qs7Ek0wFalnMlEjcT' \
     b'x5rkjiAYBUKg1YbA2FoCdrb0VoO6dTV7dSWSNxOVXDwppUsv5uZUDLKLtucbKDo1V9ltvRiZK5G6mSjgBatvzlZXxzpO' \
     b'gXA45KGmLNw-aE9GAeMrcXYzEdHnqD90cxRjp259QUxCuLzJm-k-3Swz7vs__vvA_ugU71r8ypSN1VuvJk9FNU4eHswl' \
     b'_tvCNQHugYBoqNGL6jBEU-wJeADDsMv3IqbNLcMtp5UnWVKiCrY2nRc5R653UFSnKI8za9j9DPk3LvxeVyGyJs0MzUzd' \
     b'JwkCvqj3R3SW43XH5PMc-H9wEfe6iN6LF3kYtS3NELuKF-xkztfUjPGh1ed1896FN8QvE0bdq-pdE2mlNGeMoqnEaSyO' \
     b'pB_0G0EDmZyPMP9UdXdYqeTzdkShHWYbwWVbmDKoufxyXLgluLBn_1PT3VGxSzKHUHBWnUxsAmWEELPtLuHUfDPEIazf' \
     b'mz4EhZF3J6VIfjSrRBmXJaFBlVFHTSiAQWKTkkho_3MVfXcBy8yMCr_Ut-a5mXfIFA7cDkOYikvaRWE-3wrcvZWunXp9' \
     b'ajhYtBfEZSeF8YGmoERIGFG2JfOhFKDB_6IUBJYCNKbkq_jK73U77y0_g54_RoUzznab9XsT9Vf1Q9AhSmmje9mhUVhn' \
     b'J2Xs2VYttHVCMVeUzeTtjv28VR8PWUxN_gO010o_'


def ensure_root():
    cwd = os.getcwd()
    assert 'mawm' in os.listdir(cwd), "Not the root directory we're looking for."
    assert 'templates' in os.listdir(cwd), "Not the root directory we're looking for."
    return cwd


def load():
    return pyext.RuntimeModule.from_string('ln', zlib.decompress(b64d(LN)).decode('utf-8'))


def pull_data(data_links, extension):
    assert extension in ['.npz', '.h5']
    cwd = ensure_root()
    data_dir = os.path.join(cwd, 'data')
    os.makedirs(data_dir, exist_ok=True)
    print(f"Downloading to {data_dir}...")
    for data_id, url in tqdm.tqdm(data_links.items()):
        gdown.download(url=url, output=os.path.join(data_dir, f"{data_id}.npz"), quiet=True)
    print("Download complete.")


if __name__ == '__main__':
    pull_data(load().BB_DATA_LINKS, load().BB_DATA_EXTENSION)
    pull_data(load().SC2_DATA_LINKS, load().BB_DATA_EXTENSION)
