#!/bin/bash

# Array of random seeds
seeds=(1 2 3)

# Array of configuration files
configs=("mlora_boolq.json" "mlora_obqa.json" "mlora_arc_c.json" "mlora_arc_e.json" "mlora_climateqa.json")

# Array of CUDA devices
devices=(0 1 2 3 4)

# Loop through the seeds
for seed in "${seeds[@]}"; do
    # Loop through the configurations
    for i in "${!configs[@]}"; do
        config=${configs[$i]}
        device=${devices[$i]}
        
        # Extract the base name from the config file (removing .json)
        base_name=$(basename "$config" .json)
        
        # Construct the directory and log file names
        dir="res_${base_name}_seed${seed}"
        log_file="${base_name}_test_seed${seed}.log"
        
        # Run the command
        python ./launch.py evaluate \
            --base_model meta-llama/Llama-2-7b-hf \
            --random_seed "$seed" \
            --dir "$dir" \
            --config "$config" \
            --log_file "$log_file" \
            --cuda_device "$device" &
    done
    
    # Wait for all background processes to finish before starting the next seed
    wait
done