# ETSformer: Exponential Smoothing Transformers for Time-series Forecasting

## Requirements

The recommended requirements for ETSformer are specified as follows:
* Python 3.8
* scipy==1.6.1
* torch==1.9.0
* numpy==1.19.2
* pandas==1.0.1
* scikit_learn==0.24.1
* einops==0.3.0

The dependencies can be installed by:
```bash
pip install -r requirements.txt
```

## Data
Pre-processed datasets can be downloaded from the following links, [Tsinghua Cloud](https://cloud.tsinghua.edu.cn/d/e1ccfff39ad541908bae/) or [Google Drive](https://drive.google.com/drive/folders/1ZOYpTUa82_jCcxIdTmyr0LXQfvaM9vIy?usp=sharing), as obtained from the following GitHub repository, [Autoformer](https://github.com/thuml/Autoformer). 

## Usage

1. Install Python 3.8, PyTorch 1.12.0.
2. Download data as above, and place them in the folder, `dataset/`.
3. Train the model. We provide the experiment scripts of all benchmarks under the folder `./scripts`. You can reproduce the experiment results by:

```bash
./scripts/ETT_script/ETSformer_ETTh1.sh
./scripts/ETT_script/ETSformer_ETTh2.sh
./scripts/ETT_script/ETSformer_ETTm1.sh
./scripts/ETT_script/ETSformer_ETTm2.sh
./scripts/ECL_script/ETSformer.sh
./scripts/Exchange_script/ETSformer.sh
./scripts/Traffic_script/ETSformer.sh
./scripts/Weather_script/ETSformer.sh
./scripts/ILI_script/ETSformer.sh
```
