import numpy as np
from .utils import znormalize_rows


def sample_context_pool(M: int, d: int, seed: int = 0) -> np.ndarray:
    rng = np.random.default_rng(seed)
    X = rng.normal(size=(M, d))
    return znormalize_rows(X)
