import numpy as np


def sqexp_kernel(X: np.ndarray, Y: np.ndarray, lengthscale: float) -> np.ndarray:
    X = np.asarray(X, dtype=float)
    Y = np.asarray(Y, dtype=float)
    X2 = (X ** 2).sum(axis=1)[:, None]
    Y2 = (Y ** 2).sum(axis=1)[None, :]
    D2 = X2 + Y2 - 2.0 * X @ Y.T
    return np.exp(-0.5 * D2 / (lengthscale ** 2))


def matern52_kernel(X: np.ndarray, Y: np.ndarray, lengthscale: float) -> np.ndarray:
    X = np.asarray(X, dtype=float)
    Y = np.asarray(Y, dtype=float)
    X2 = (X ** 2).sum(axis=1)[:, None]
    Y2 = (Y ** 2).sum(axis=1)[None, :]
    D2 = X2 + Y2 - 2.0 * X @ Y.T
    r = np.sqrt(np.maximum(D2, 0.0)) / lengthscale
    return (1.0 + np.sqrt(5.0) * r + 5.0 / 3.0 * (r ** 2)) * np.exp(-np.sqrt(5.0) * r)
