import argparse
import yaml
from lkb.benchmark import BenchmarkConfig, run_benchmark


def main() -> None:
    parser = argparse.ArgumentParser()
    parser.add_argument("--config", type=str, required=True)
    args = parser.parse_args()

    with open(args.config, "r") as f:
        d = yaml.safe_load(f)

    cfg = BenchmarkConfig(**d)
    run_benchmark(cfg)


if __name__ == "__main__":
    main()
