import random
import numpy as np


def set_all_seeds(seed: int) -> None:
    np.random.seed(seed)
    random.seed(seed)


def znormalize_rows(X: np.ndarray, eps: float = 1e-12) -> np.ndarray:
    X = np.asarray(X, dtype=float)
    norms = np.linalg.norm(X, axis=1, keepdims=True)
    norms = np.maximum(norms, eps)
    return X / norms
